-- Copyright (C) 2025 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
--
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X
-- T GNU         ~~==__       ~~~===___               ___===~~~      __==~~                 T
-- | PROPAGANDA        ~~== __     OSS ~~~=========~~~ CUCKS   __==~~      If you need more |
-- | DEPARTMENT               ~~~===___    BIGGEST    ___===~~~            encouragment...  |
--                                     ~~~=========~~~                     all of those men  
--                                                                         are balding       
-- |                           1. Andrew S. Tanenbaum (minix)                               |
-- |   3. Linus torvalds (linux                            2. George Neville-Neil (freeBSD) |
--                       foundation)          O /          |                                 
--        YOU?                     |         /|/     /O\ <-'    +=====================+      
-- |       o    <- consellation    '->  O    `|      \|/        | REMEMBER KIDS       |     |
-- |      /|\    price for MIT         /|\   / \      |         | LICENSE  EVERYTHING |     |
--       / | \   license users.        `|/ |~~~~~~|  / \        | UNDER    THE AGPLv3 |      
--        / \    Notice the smaller    /T\ |  #1  |~~~~~~|      +=====================+      
-- |    |~~~~~~| head               |~~~~~~|      |  #2  |        |               |         |
-- |    |  #C  |                    |  #3  |      |      |        |               |         |
-- V OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO V
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X

local function deg_to_rad(deg)
	return (deg / 180) * math.pi
end

local function clamp(val, min, max)
	return math.min(max, math.max(val, min))
end

local function angle_diff(a, b)
	return ((a - b + math.pi) % (math.pi * 2)) - math.pi
end

-- This is hell on earth
-- Edit: this is actually quite pleasant once you stop using deprecated functions...

local max_control_distance = 3
local shooting_offset = vector.new(0, 1.4, 0)
local shooting_barrel_length = 4

local min_barrel_pitch = deg_to_rad(-25)
local max_barrel_pitch = deg_to_rad(3)
local barrel_pitch_follow_speed = deg_to_rad(15)
local barrel_pitch_change_threshold = deg_to_rad(1)

local min_barrel_yaw = deg_to_rad(-5)
local max_barrel_yaw = deg_to_rad(5)
local barrel_yaw_follow_speed = deg_to_rad(5)

local trail_increment = deg_to_rad(2)
local fun_magic_number = 1.5
local min_trail_yaw = deg_to_rad(-2.5)
local max_trail_yaw = deg_to_rad(15)
local min_trail_pitch = deg_to_rad(-10)
local max_trail_pitch = 0

local trail_start_length = 1.75
local trail_length = 3.35
local left_trail_rotation_offset = deg_to_rad(120)
local right_trail_rotation_offset = deg_to_rad(110)

local artillery_air_drag = 1
local artillery_block_drag = 5

local recoil_strength = 2.5 -- this should be proportional to the gas emission of the load, but whatever
local yaw_rotation_max_recoil = deg_to_rad(40)

local min_body_pitch = deg_to_rad(-10)
local max_body_pitch = deg_to_rad(2)
local body_follow_speed = deg_to_rad(40)
local wheel_turning_speed = deg_to_rad(35)

core.register_entity("hl:artillery", {
	initial_properties = {
		hp_max = 10000,
		physical = true,
		visual = "mesh",
		mesh = "artillery.glb",
		use_texture_aplha = true,
		backface_culling = false,
		pointable = true,
		textures = {"artillery.png"},
		static_save = true,
		collisionbox = {-0.4, 0, -0.4, 0.4, 1.5, 0.4},
		stepheight = 1.25,
	},

	right_wheel_rot = 0,
	left_wheel_rot = 0,


	barrel_pitch = 0,
	barrel_yaw = 0,

	trail_yaw = 0,
	trail_control_cooldown = 0,
	trail_pitch = 0,

	body_yaw = 0,
	body_pitch = 0,

	controlling_player = nil,
	controlling_player_name = nil, -- required for the case when the player leaves the server
	control_time = 0,
	increment_wheel_rot = function(self, num)
		self.right_wheel_rot = self.right_wheel_rot - num
		self.left_wheel_rot = self.left_wheel_rot + num

		self:update_wheel_rot()
	end,

	update_wheel_rot = function(self)
		self.object:set_bone_override(
			"Left Wheel",
			{
				rotation = {vec = vector.new(0, self.left_wheel_rot, 0), interpolation = 0.1}
			}
		)
		self.object:set_bone_override(
			"Right Wheel",
			{
				rotation = {vec = vector.new(0, self.right_wheel_rot, 0), interpolation = 0.1}
			}
		)
	end,

	follow_player_look = function(self, dtime)
		if not self.controlling_player then return end

		local player_pitch = self.controlling_player:get_look_vertical()
		local pitch_diff = self.barrel_pitch - player_pitch
		if math.abs(pitch_diff) > barrel_pitch_change_threshold then
			self.barrel_pitch = clamp(self.barrel_pitch + -math.sign(pitch_diff) * barrel_pitch_follow_speed * dtime, min_barrel_pitch, max_barrel_pitch)
			self.object:set_bone_override(
				"Vertical Aim",
				{
					rotation = {
						vec = vector.new(self.barrel_pitch, 0, 0),
						interpolation = 0.1
					}
				}
			)

			self.object:set_bone_override(
				"Aiming Wheel",
				{
					-- position = {vec = aiming_wheel_offset},
					rotation = {vec = vector.new(0, self.barrel_pitch * 8, 0)},
					interpolation = 0.1
				}
			)
		end

		local player_yaw = self.controlling_player:get_look_horizontal()
		local yaw_diff = angle_diff(player_yaw + self.barrel_yaw, self.body_yaw)
		self.barrel_yaw = clamp(self.barrel_yaw + -math.sign(yaw_diff) * barrel_yaw_follow_speed * dtime, min_barrel_yaw, max_barrel_yaw)

		self.object:set_bone_override(
			"Horizontal Aim",
			{
				rotation = {vec = vector.new(0, self.barrel_yaw, 0)},
				interpolation = 0.1
			}
		)
	end,

	follow_player_look_whole = function(self, dtime)
		if self.trail_yaw == min_trail_yaw then
			local player_yaw = self.controlling_player:get_look_horizontal()
			local yaw_diff = angle_diff(player_yaw, self.body_yaw)
			self.body_yaw = ((self.body_yaw + math.sign(yaw_diff) * body_follow_speed * dtime) % (math.pi * 2))

			self.right_wheel_rot = self.right_wheel_rot + math.sign(yaw_diff) * wheel_turning_speed * dtime
			self.left_wheel_rot = self.right_wheel_rot - math.sign(yaw_diff) * wheel_turning_speed * dtime

			local body_dir = vector.new(math.cos(self.body_yaw + math.pi / 2), 0, math.sin(self.body_yaw + math.pi / 2))
			local player_dir = vector.normalize(self.controlling_player:get_velocity())

			body_dir.x = math.abs(body_dir.x) * player_dir.x
			body_dir.z = math.abs(body_dir.z) * player_dir.z

			if body_dir.x ~= 0 or body_dir.z ~= 0 then
				-- self.object:add_velocity(vector.multiply(body_dir, player_velocity))
				self.object:add_velocity(vector.multiply(body_dir, dtime * 6))
				self:increment_wheel_rot(vector.length(body_dir) * dtime)
			end

			self:update_wheel_rot()
		end

		local player_pitch = self.controlling_player:get_look_vertical()
		local pitch_diff = self.body_pitch - player_pitch
		self.body_pitch = clamp(self.body_pitch + -math.sign(pitch_diff) * body_follow_speed * dtime, min_body_pitch, max_body_pitch)

		self.object:set_bone_override(
			"Master Bone",
			{
				rotation = {vec = vector.new(self.body_pitch, 0, 0), interpolation = 0.1}
			}
		)
		self.object:set_yaw(self.body_yaw)
		self:update_trail_state()
	end,

	increment_trail_rot = function(self, num)
		self.trail_control_cooldown = 1

		self.trail_yaw = clamp(self.trail_yaw + num, min_trail_yaw, max_trail_yaw)
		self.trail_pitch = max_trail_pitch

		self:update_trail_state()
	end,

	update_trail_state = function(self)
		self.object:set_bone_override(
			"Left Trail",
			{
				rotation = {
					vec = vector.new(
						self.trail_pitch - self.body_pitch * fun_magic_number,
						0,
						self.trail_yaw
					),
					interpolation = 0.2,
				}
			}
		)
		self.object:set_bone_override(
			"Right Trail",
			{
				rotation = {
					vec = vector.new(
						self.trail_pitch - self.body_pitch * fun_magic_number,
						0,
						-self.trail_yaw
					),
					interpolation = 0.2,
				}
			}
		)
	end,

	check_trail_stability = function(self)

		if self.trail_yaw == min_trail_yaw then
			return 0, 0
		end

		local self_pos = self.object:get_pos()

		local left_node = core.get_node(
			self.object:get_pos()
			+ vector.new(trail_start_length * math.cos(self.body_yaw - right_trail_rotation_offset), -0.5, trail_start_length * math.sin(self.body_yaw - right_trail_rotation_offset))
			+ vector.new(trail_length * math.cos(self.body_yaw - self.trail_yaw - right_trail_rotation_offset), 0, trail_length * math.sin(self.body_yaw - self.trail_yaw - right_trail_rotation_offset))
		)

		local right_node = core.get_node(
			self_pos
			+ vector.new(trail_start_length * math.cos(self.body_yaw - left_trail_rotation_offset), -0.5, trail_start_length * math.sin(self.body_yaw - left_trail_rotation_offset))
			+ vector.new(trail_length * math.cos(self.body_yaw + self.trail_yaw - left_trail_rotation_offset), 0, trail_length * math.sin(self.body_yaw + self.trail_yaw - left_trail_rotation_offset))
		)

		local trail_extension = (self.trail_yaw + math.abs(min_trail_yaw)) / (math.abs(max_trail_yaw) + math.abs(min_trail_yaw))
		local left_strength = core.get_item_group(left_node.name, "shovely") > 0 and trail_extension or 0
		local right_strength = core.get_item_group(right_node.name, "shovely") > 0 and trail_extension or 0

		return left_strength, right_strength
	end,

	set_controliling_player = function(self, player)
		self.controlling_player = player
		self.controlling_player_name = player:get_player_name()
		core.change_player_privs(player:get_player_name(), {interact = false})
		player:set_physics_override(
			{
				speed_walk = 0.25,
				speed_crouch = 0.25
			}
		)
		self.control_time = 0
	end,

	unset_controlling_player = function(self)
		core.change_player_privs(self.controlling_player_name, {interact = true})
		self.controlling_player:set_physics_override(
			{
				speed_walk = 1,
				speed_crouch = 1
			}
		)
		self.controlling_player = nil
		self.controlling_player_name = nil
		self.control_time = 0
	end,

	update_body_state = function(self)
		self.object:set_yaw(self.body_yaw)
		self:update_trail_state()
		self.object:set_bone_override(
			"Master Bone",
			{
				rotation = {vec = vector.new(self.body_pitch, 0, 0), interpolation = 0.1}
			}
		)
	end,

	on_rightclick = function(self, clicker)
		if not core.is_player(clicker) then return end

		local controls = clicker:get_player_control()

		if controls.sneak then
			self:increment_trail_rot(trail_increment)
		else
			self:set_controliling_player(clicker)
		end
	end,

	on_death = function(self, killer)
		if self.controlling_player_name and self.controlling_player then
			self:unset_controlling_player()
		end
	end,

	on_punch = function(self, puncher, time_from_last_punch, tool_capabilities, dir, damage)
		if not puncher:is_player() then return end

		local controls = puncher:get_player_control()
		local wielded_item = puncher:get_wielded_item()

		if controls.sneak then
			self:increment_trail_rot(-trail_increment)
		elseif wielded_item:get_name() == "hl:1m_round" then

			if self.load then
				local success, itemstack = hl.create_round_itemstack("hl:1m_round", hl.deserialize_load(self.load))
				if not success then
					-- i dont fucking know bro
					core.log("error", "somehow the artillery has an invalid load")
				else
					core.add_item(self.object:get_pos(), itemstack)
				end
			end

			if core.get_item_group(wielded_item:get_name(), "hl_round") < 0 then
				return
			end

			self.load = wielded_item:get_meta():get_string("heavy_load")

			if not core.is_creative_enabled(puncher:get_player_name()) then
				puncher:set_wielded_item("")
			end
		end
	end,

	on_activate = function(self, staticdata, dtime_s)
		local deserialized_data = core.deserialize(staticdata)

		if not deserialized_data then return end

		-- i don't know if this is the proper way to do this. But i don't care anymore
		-- im so tired of this bullshit
		self.right_wheel_rot = deserialized_data.right_wheel_rot
		self.left_wheel_rot = deserialized_data.left_wheel_rot

		self.barrel_pitch = deserialized_data.barrel_pitch
		self.barrel_yaw = deserialized_data.barrel_yaw
		self.inc = deserialized_data.inc

		self.trail_yaw = deserialized_data.trail_yaw
		self.trail_control_cooldown = deserialized_data.trail_control_cooldown
		self.trail_pitch = deserialized_data.trail_pitch

		self.body_yaw = deserialized_data.body_yaw
		self.body_pitch = deserialized_data.body_pitch

		self.controlling_player = deserialized_data.controlling_player
		self.controlling_player_name = deserialized_data.controlling_player_name
		self.control_time = deserialized_data.control_time

		self:update_body_state()
	end,

	on_deactivate = function(self, removal)
		if self.controlling_player_name and self.controlling_player then
			self:unset_controlling_player()
		end
	end,

	get_staticdata = function(self)
		return core.serialize({
			right_wheel_rot = self.right_wheel_rot,
			left_wheel_rot = self.left_wheel_rot,

			barrel_pitch = self.barrel_pitch,
			barrel_yaw = self.barrel_yaw,

			trail_yaw = self.trail_yaw,
			trail_control_cooldown = self.trail_control_cooldown,
			trail_pitch = self.trail_pitch,

			body_yaw = self.body_yaw,
			body_pitch = self.body_pitch,

			controlling_player_name = self.controlling_player_name,
			control_time = self.control_time,

			load = self.load
		})
	end,

	on_step = function(self, dtime, moveresult)

		if self.object:get_attach() then
			return
		end

		local self_pos = self.object:get_pos()

		if self.bring_back_timer and self.bring_back_timer > 0 then
			self.bring_back_timer = self.bring_back_timer - dtime

			if self.bring_back_timer < 0 then
				self.object:set_bone_override("Barrel", {
					position = {
						vec = vector.new(0, 0, 0),
						interpolation = 0.3
					}
				})
			end
		end

		if self.controlling_player then
			self.control_time = self.control_time + dtime
			local player_controls = self.controlling_player:get_player_control()

			if player_controls.LMB then
				if self.load then
					core.sound_play(
						{
							name = "artillery-shot"
						},
						{
							gain = 1,
							object = self.object
						},
						true
					)

					local total_yaw = self.body_yaw - self.barrel_yaw
					local total_pitch = self.body_pitch + self.barrel_pitch

					local offset_horizontal_z = math.cos(self.body_yaw - self.barrel_yaw - math.pi / 2)
					local offset_horizontal_x = math.sin(self.body_yaw - self.barrel_yaw - math.pi / 2)
					local total_horizontal_length = math.sqrt(math.pow(offset_horizontal_z, 2) + math.pow(offset_horizontal_x, 2))

					-- In 2022 Jim Carey announced that he was considering retirement, saying 'I have enough, I've done enough. I am enough' - he said
					---he would only return if he were offered a script that he felt 'would be really for people to see'.... In February 2024 he
					-- announced that he would reprise his role of Dr Robotnik in Sonic the Hedgehog 3'

					-- really funny comment i saw under some video. The best part is that its not even supposed to be humorous

					-- check out this spiral i made in ascii art (it might look horrible with your font)

					--                 _____               ',      
					--           _.dHHHHHHHHHHHHb.          `P.    
					--       _.dHHHHP"~^^^`~%HHHHHHb,        ^$b   
					--     .$HHP~^            `~HHHHHH,       ^Hb  
					--    dHHP       _dHHHHHHb_  ^~HHHHb       9Hb 
					--  .dHH      .dHHHHHHHHHHHHb  ^HHHH:      :HH.
					-- .HHH      dHHHHHHHHHHHHHHHb  IHHHH:      HH:
					--.HHP      dHHHHHHHHHHHHHHHHHbdHHHHH;     .$H;
					--;HP      :HHHHHHHHHHHHHHHHHHHHHHHHH'     dHH 
					--:H:      :HHHH' `HHHHHHHHHHHHHHHHH'     dHHP 
					--:H;      ;HHHH,  "HHHHHHHHHHHHHH"^    .dHHP  
					-- HH       $HHHH.  ^"HHHHHHHHHH~^    .dHHH^   
					-- 'H.       "$HHHb._     ^~~~^    .dHHHHP     
					--  Ib;       "HHHHHHHb=.______.dHHHHH$P^      
					--   `Hb        `"=HHHHHHHHHHHHHHHHH'^         
					--     ":           `^~+HHHHHP~~``             
					--       `                                     

					-- those curves bro. They're so crisp

					-- this whole branch should have been abstracted away in a function. But i don't feel like doing so. Not
					-- because it would take effort. But because i think there is a sense in which this code is at home here

					-- Edit: The code was majorily (is that even a word?) changed, and now this mess feels less like home,
					-- maybe i should move it?

					-- Bro. Imagine if lua was the language used by the browsers instead of javascript. Lua is everything
					-- javascript wished it was. The perfect prototype language (lua 5.1)

					local barrel_end_pos = self_pos
						+ shooting_offset
						+ vector.new(
							shooting_barrel_length * -offset_horizontal_z / total_horizontal_length,
							shooting_barrel_length * math.sin(-total_pitch),
							shooting_barrel_length * -offset_horizontal_x / total_horizontal_length
					)
					local barrel_rotation = vector.normalize(core.yaw_to_dir(total_yaw) + vector.new(0, (total_pitch) / (-math.pi / 2), 0))

					hl.process_load(
						hl.deserialize_load(self.load),
						barrel_end_pos,
						barrel_rotation
					)

					core.add_particlespawner({
						amount = 40,
						time = 0.25,
						pos = {
							min = vector.offset(barrel_end_pos, 0.05, 0.05, 0.05),
							max = vector.offset(barrel_end_pos, -0.05, -0.05, -0.05),
						},
						vel = vector.multiply(barrel_rotation, 20),
						attract = {
							kind = "line",
							direction = barrel_rotation,
							strength = -25,
							origin = barrel_end_pos
						},
						exptime = {
							min = 0.75,
							max = 1,
						},
						size = {
							min = 1,
							max = 5
						},
						texpool = {
							{
								name = "smoke_1.png",
								blend = "clip",
							},
							{
								name = "smoke_2.png",
								blend = "clip",
							},
							{
								name = "smoke_3.png",
								blend = "clip",
							}
						}
					})

					if not core.is_creative_enabled(self.controlling_player:get_player_name()) then
						self.load = nil
					end

					local left_strength, right_strength = self:check_trail_stability()

					if left_strength ~= 1 or right_strength ~= 1 then
						self.body_yaw = self.body_yaw + ((left_strength - right_strength) * yaw_rotation_max_recoil)
						self.object:add_velocity(vector.new(recoil_strength * math.cos(self.body_yaw - math.pi / 2), 0, recoil_strength * math.sin(self.body_yaw - math.pi / 2)))
						self:update_body_state()
					end

					self.object:set_bone_override("Barrel", {
						position = {
							vec = vector.new(0, 0, -1.25),
							interpolation = 0.4
						}
					})
					self.bring_back_timer = 0.3
				end

			end

			if vector.distance(self_pos, self.controlling_player:get_pos()) > max_control_distance then
				self:unset_controlling_player()
			elseif player_controls.sneak and self.control_time > 0.5 then
				self:unset_controlling_player()
			elseif player_controls.aux1 then
				self:follow_player_look_whole(dtime)
			else
				self:follow_player_look(dtime)
			end
		end

		self.trail_control_cooldown = self.trail_control_cooldown - dtime

		self.object:add_velocity(vector.new(0, -10 * dtime, 0))

		if self.trail_control_cooldown < 0 and self.trail_yaw ~= min_trail_yaw then
			self.trail_pitch = min_trail_pitch
			self:update_trail_state()
		end

		local standing_on = core.get_node(vector.offset(self_pos, 0, -0.5, 0))
		local self_velocity = self.object:get_velocity()
		local new_velocity = vector.multiply(
			vector.offset(self_velocity, 0, dtime * -10, 0),
			1 - (artillery_air_drag * dtime * (moveresult.touching_ground and artillery_block_drag / (core.get_item_group(standing_on.name, "slippery") + 1 or 1) or 1))
		)
		self.object:set_velocity(new_velocity)
	end
})

-- toiemnvrqdljtdypfmsgtiemsrnoehkenzart
--  WHY ARE THE TRAIL ENDS ASSYMETRICAL
-- stvrmtzeuarsntinearzstieqkwrmtvneamro
