-- Copyright (C) 2025 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
--
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X
-- T GNU         ~~==__       ~~~===___               ___===~~~      __==~~                 T
-- | PROPAGANDA        ~~== __     OSS ~~~=========~~~ CUCKS   __==~~      If you need more |
-- | DEPARTMENT               ~~~===___    BIGGEST    ___===~~~            encouragment...  |
--                                     ~~~=========~~~                     all of those men  
--                                                                         are balding       
-- |                           1. Andrew S. Tanenbaum (minix)                               |
-- |   3. Linus torvalds (linux                            2. George Neville-Neil (freeBSD) |
--                       foundation)          O /          |                                 
--        YOU?                     |         /|/     /O\ <-'    +=====================+      
-- |       o    <- consellation    '->  O    `|      \|/        | REMEMBER KIDS       |     |
-- |      /|\    price for MIT         /|\   / \      |         | LICENSE  EVERYTHING |     |
--       / | \   license users.        `|/ |~~~~~~|  / \        | UNDER    THE AGPLv3 |      
--        / \    Notice the smaller    /T\ |  #1  |~~~~~~|      +=====================+      
-- |    |~~~~~~| head               |~~~~~~|      |  #2  |        |               |         |
-- |    |  #C  |                    |  #3  |      |      |        |               |         |
-- V OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO V
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X

function hl.standard_benchmarks_for_component(component_name)
	local benchmarks = {}

	benchmarks.dirt = hl.benchmark_component_against(component_name, "mcl_core:dirt")
	benchmarks.stone = hl.benchmark_component_against(component_name, "mcl_core:stone")
	benchmarks.deepslate = hl.benchmark_component_against(component_name, "mcl_deepslate:deepslate")
	benchmarks.reinforced_brick = hl.benchmark_component_against(component_name, "hl:reinforced_brick")
	benchmarks.obsidian = hl.benchmark_component_against(component_name, "mcl_core:obsidian")
	benchmarks.reinforced_obsidian = hl.benchmark_component_against(component_name, "hl:reinforced_obsidian")

	return benchmarks
end

function hl.benchmark_component_against(component_name, nodename)
	local benchmark = {}
	local ndef = core.registered_nodes[nodename]
	local cdef = hl.registered_loads[component_name]

	core.debug("nodename: ", nodename)
	benchmark.penetration_limit = cdef.hardness / ndef._mcl_hardness

	-- this is a shortened version, after some simplifications
	-- the full formula:
	-- (e / m) / ((nh * k) / m) = (ch / nh)
	-- where:
	-- right side - the penetration limit
	-- left side - the formula for amount of block traveled
	--
	-- e - gas emission needed (this is what we solve for)
	-- m - mass
	-- nh - node hardness
	-- k - the hardness slowing multiplier
	-- ch - component hardness
	benchmark.gas_needed_for_full_utilization = cdef.hardness * hl.hardness_slowing_mul

	return benchmark
end

function hl.render_benchmarks(benchmarks)
	local str = ""

	for benchmark_name, benchmark in pairs(benchmarks) do
		str = str .. benchmark_name .. ":\n"
		str = str .. "\tpenetration " .. benchmark.penetration_limit .. " blocks\n"
		str = str .. "\tgas needed for full utilization " .. benchmark.gas_needed_for_full_utilization .. "\n"
	end

	return str
end
