-- Copyright (C) 2025 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
--
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X
-- T GNU         ~~==__       ~~~===___               ___===~~~      __==~~                 T
-- | PROPAGANDA        ~~== __     OSS ~~~=========~~~ CUCKS   __==~~      If you need more |
-- | DEPARTMENT               ~~~===___    BIGGEST    ___===~~~            encouragment...  |
--                                     ~~~=========~~~                     all of those men  
--                                                                         are balding       
-- |                           1. Andrew S. Tanenbaum (minix)                               |
-- |   3. Linus torvalds (linux                            2. George Neville-Neil (freeBSD) |
--                       foundation)          O /          |                                 
--        YOU?                     |         /|/     /O\ <-'    +=====================+      
-- |       o    <- consellation    '->  O    `|      \|/        | REMEMBER KIDS       |     |
-- |      /|\    price for MIT         /|\   / \      |         | LICENSE  EVERYTHING |     |
--       / | \   license users.        `|/ |~~~~~~|  / \        | UNDER    THE AGPLv3 |      
--        / \    Notice the smaller    /T\ |  #1  |~~~~~~|      +=====================+      
-- |    |~~~~~~| head               |~~~~~~|      |  #2  |        |               |         |
-- |    |  #C  |                    |  #3  |      |      |        |               |         |
-- V OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO V
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X

-- {{{ Craft items

core.register_node("hl:basic_fuse_casing", {
	description = "Basic fuse casing",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"basic_fuse_casing.png"}
})

core.register_node("hl:advanced_fuse_casing", {
	description = "Advanced fuse casing",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"advanced_fuse_casing.png"}
})

-- }}}

-- {{{ Primitive penetration fuse

core.register_node("hl:primitive_penetration_fuse",
{
	description = "Primitive penetration fuse",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"primitive_penetration_fuse.png"}
})

hl.register_load_component("hl:primitive_penetration_fuse", {
	hardness = 0,
	weight = 1,
	codename = "Fpp",
	compressed_size = 0.5,

	on_activate = function(self, pos, load)
		self.state = "inactive"
	end,
	on_step = function(self, pos, load, current_node)
		if self.state == "primed" and current_node.name == "air" then
			return "explode"
		elseif self.state == "inactive" and current_node.name ~= "air" then
			self.state = "primed"
		end
	end
})

-- }}}

-- {{{ Sophisticated penetration fuse

core.register_node("hl:sophisticated_penetration_fuse",
{
	description = "Sophisticated penetration fuse",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"sophisticated_penetration_fuse.png"}
})

hl.register_load_component("hl:sophisticated_penetration_fuse", {
	hardness = 0,
	weight = 1,
	codename = "Fsp",
	compressed_size = 0.5,

	on_activate = function(self, pos, load)
		self.state = "inactive"
	end,
	on_step = function(self, pos, load, current_node)
		if self.state == "primed" and current_node.name == "air" then
			self.state = "last_phase"
		elseif current_node.name ~= "air" then
			if self.state == "inactive" then
				self.state = "primed"
			elseif self.state == "last_phase" then
				return "explode"
			end
		end
	end
})

-- }}}

-- {{{ Frontal proximity fuse

core.register_node("hl:frontal_proximity_fuse",
{
	description = "Frontal proximity fuse",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"frontal_proximity_fuse.png", "frontal_proximity_fuse.png", "frontal_proximity_fuse.png", "frontal_proximity_fuse.png", "frontal_proximity_fuse.png", "frontal_proximity_fuse.png", }
})

hl.register_load_component("hl:frontal_proximity_fuse", {
	hardness = 0,
	weight = 1,
	codename = "Ffp",
	compressed_size = 0.5,

	on_step = function(self, pos, load, current_node)
		local dir = vector.normalize(load.velocity)
		local ray = core.raycast(pos, pos + (dir * 5), false, true)

		for pointed_thing in ray do
			if core.get_item_group(core.get_node(pointed_thing.under).name, "solid") > 0 then
				return "explode"
			end
		end

	end
})


-- }}}

-- {{{ Gyroscoped proximity fuse

core.register_node("hl:gyro_proximity_fuse",
{
	description = "Gyroscoped proximity fuse",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"gyro_proximity_fuse.png"}
})

hl.register_load_component("hl:gyro_proximity_fuse", {
	hardness = 0,
	weight = 1,
	codename = "Fgp",
	compressed_size = 0.5,

	on_activate = function(self)
		self.state = "inactive"
		self.counter = 0
	end,
	on_step = function(self, pos, load, current_node)
		local ray = core.raycast(pos, vector.offset(pos, 0, -5, 0), false, true)

		local found_anything = true
		for pointed_thing in ray do
			if core.get_item_group(core.get_node(pointed_thing.under).name, "solid") > 0 then
				if self.state == "primed" and self.counter > 8 then
					return "explode"
				end
				found_anything = false
			end
		end

		if found_anything then
			self.state = "primed"
		end

		self.counter = self.counter + 1
	end
})

-- }}}
