-- Copyright (C) 2025 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
--
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X
-- T GNU         ~~==__       ~~~===___               ___===~~~      __==~~                 T
-- | PROPAGANDA        ~~== __     OSS ~~~=========~~~ CUCKS   __==~~      If you need more |
-- | DEPARTMENT               ~~~===___    BIGGEST    ___===~~~            encouragment...  |
--                                     ~~~=========~~~                     all of those men  
--                                                                         are balding       
-- |                           1. Andrew S. Tanenbaum (minix)                               |
-- |   3. Linus torvalds (linux                            2. George Neville-Neil (freeBSD) |
--                       foundation)          O /          |                                 
--        YOU?                     |         /|/     /O\ <-'    +=====================+      
-- |       o    <- consellation    '->  O    `|      \|/        | REMEMBER KIDS       |     |
-- |      /|\    price for MIT         /|\   / \      |         | LICENSE  EVERYTHING |     |
--       / | \   license users.        `|/ |~~~~~~|  / \        | UNDER    THE AGPLv3 |      
--        / \    Notice the smaller    /T\ |  #1  |~~~~~~|      +=====================+      
-- |    |~~~~~~| head               |~~~~~~|      |  #2  |        |               |         |
-- |    |  #C  |                    |  #3  |      |      |        |               |         |
-- V OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO V
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X

local infernal_fire_max_float_distance = 5

local wash_away_offsets = {
	vector.new(1,  0, 0),
	vector.new(-1, 0, 0),
	vector.new(0,  0, 1),
	vector.new(0,  0, -1),
}

core.register_node("hl:infernal_flame", {
	description = "Infernal flame",
	drawtype = "firelike",
	tiles = {
		{
			name = "infernal_flame.png",
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 1
			},
		},
	},
	-- inventory_image = "fire_basic_flame.png",
	paramtype = "light",
	light_source = core.LIGHT_MAX,
	walkable = false,
	buildable_to = true,
	sunlight_propagates = true,
	damage_per_second = 2,
	groups = {fire = 1, dig_immediate = 3, not_in_creative_inventory = 0, dig_by_piston=1, destroys_items=1, unsticky = 1, falling_node = 1},
	floodable = true,
	on_flood = function(pos, _, newnode)
		local washed_away = false
		for _, offset in pairs(wash_away_offsets) do
			local node_name = core.get_node(pos + offset).name

			if node_name == "air" then

				local you_know_what_i_mean = vector.copy(pos + offset)
				while true do
					you_know_what_i_mean.y = you_know_what_i_mean.y - 1
					local node_name_2 = core.get_node(you_know_what_i_mean)

					if node_name_2.name ~= "air" then
						break
					end
				end

				core.set_node(vector.offset(you_know_what_i_mean, 0, 1, 0), {name = "hl:infernal_flame"})

				washed_away = true
				break
			end
		end

		if not washed_away then
			local float_offset = vector.copy(pos)
			local float_distance = 0
			while true do
				float_offset.y = float_offset.y + 1
				local node_name = core.get_node(float_offset)
				float_distance = float_distance + 1

				if float_distance > infernal_fire_max_float_distance then
					break
				end

				if node_name.name == "air" then
					core.set_node(float_offset, {name = "hl:infernal_flame"})
					break
				end
			end
		end
	end,
	on_punch = function(pos, node, puncher, pointed_thing)
		mcl_util.deal_damage(puncher, 1, {type = "in_fire"})
	end,
	drop = "",
	sounds = {},
	diggable = false,
	_pathfinding_class = "DAMAGE_FIRE",
})

local flame_entity_gravity = -15
local flame_entity_float = 5

local worker_vector = vector.new(0, 0, 0)
core.register_entity("hl:infernal_flame_entity", {
	initial_properties = {
		physical = true,
		-- collide_with_objects = true,
		collide_with_objects = false,
		pointable = false,
		visual = "sprite",
		textures = {"infernal_flame_entity.png"},
		glow = 15,
		static_save = false,
		shaded = false
	},
	on_step = function(self, dtime, moveresult)
		local obj = self.object

		if moveresult.collides then
			for _, v in pairs(moveresult.collisions) do
				if v.type == "node" then
					core.set_node(v.new_pos, {name = "hl:infernal_flame"})
					core.check_for_falling(v.new_pos)
					obj:remove()
					return
				end
			end
		end

		local obj_pos = self.object:get_pos()
		local node = core.get_node(obj_pos)
		if node.name == "air" then
			if self.in_water then
				core.set_node(obj_pos, {name = "hl:infernal_flame"})
				self.object:remove()
				return
			end
			worker_vector.y = flame_entity_gravity * dtime
			obj:add_velocity(worker_vector)
		else
			local ndef = core.registered_nodes[node.name]

			if ndef.liquidtype ~= "none" then
				worker_vector.y = flame_entity_float * dtime
				obj:add_velocity(worker_vector)
				self.in_water = true
			end
		end
	end
})

function hl.spawn_infernal_flame_entity(pos, velocity, volume)
	local obj = core.add_entity(pos, "hl:infernal_flame_entity")

	obj:set_velocity(velocity)
end

function hl.spawn_infernal_flame_explosion(pos, power, volume)
	while volume > 0 do
		local random_dir = vector.random_direction()
		random_dir.y = math.abs(random_dir.y)
		local droplet = math.random(1, 2)
		volume = volume - droplet
		hl.spawn_infernal_flame_entity(
			pos,
			vector.multiply(random_dir, power * math.random()),
			droplet
		)
	end
end

local engulfed_players = {}
core.register_globalstep(function(dtime)
	for _, player in pairs(core.get_connected_players()) do
		local player_pos = player:get_pos()
		local player_head_pos = vector.offset(player_pos, 0, 1, 0)
		local head_node = core.get_node(player_head_pos)
		local leg_node = core.get_node(player_pos)
		local head_ndef = core.registered_nodes[head_node.name]
		local leg_ndef = core.registered_nodes[leg_node.name]

		local flame_pos
		if leg_node.name == "hl:infernal_flame" then
			flame_pos = player_pos
		elseif head_node.name == "hl:infernal_flame" then
			flame_pos = player_head_pos
		elseif head_ndef.liquidtype ~= "none" and head_ndef.liquidtype ~= "none" and engulfed_players[player] then
			engulfed_players[player] = nil
			local float_offset = vector.copy(player_head_pos)
			local float_distance = 0
			while true do
				float_offset.y = float_offset.y + 1
				local node_name = core.get_node(float_offset)
				float_distance = float_distance + 1

				if float_distance > infernal_fire_max_float_distance then
					break
				end

				if node_name.name == "air" then
					core.set_node(float_offset, {name = "hl:infernal_flame"})
					break
				end
			end
		end

		if flame_pos then
			if not engulfed_players[player] then
				core.remove_node(flame_pos)
			end
			engulfed_players[player] = 10
		end

		if engulfed_players[player] then
			mcl_util.deal_damage(player, 2 * dtime, {type = "on_fire"})

			engulfed_players[player] = engulfed_players[player] - dtime

			if engulfed_players[player] < 0 then
				engulfed_players[player] = nil
			end
		end
	end
end)

core.register_abm({
	label = "Extinguish infernal flame",
	nodenames = {"hl:infernal_flame"},
	interval = 20,
	chance = 8,
	catch_up = true,
	action = function(pos)
		core.remove_node(pos)
	end,
})


-- The following code is copied verbatim from minecolonia mcl_fire
-- I don't really like it... But i can't think of an elegant solution

local adjacents = {
	{ x =-1, y = 0, z = 0 },
	{ x = 1, y = 0, z = 0 },
	{ x = 0, y = 1, z = 0 },
	{ x = 0, y =-1, z = 0 },
	{ x = 0, y = 0, z =-1 },
	{ x = 0, y = 0, z = 1 },
}

local function has_flammable(pos)
	for _,v in pairs(adjacents) do
		local p=vector.add(pos,v)
		local n=core.get_node_or_nil(p)
		if n and core.get_item_group(n.name, "flammable") ~= 0 then
			return p
		end
	end
end

local function check_aircube(p1,p2)
	local nds=core.find_nodes_in_area(p1,p2,{"air"})
	table.shuffle(nds)
	for _, v in pairs(nds) do
		if has_flammable(v) then return v end
	end
end

local function get_ignitable(pos)
	return check_aircube(vector.add(pos,vector.new(-1,-1,-1)),vector.add(pos,vector.new(1,4,1)))
end

local function spawn_fire(pos, age)
	core.set_node(pos, {name="mcl_fire:fire", param2 = age})
	core.check_single_for_falling({x=pos.x, y=pos.y+1, z=pos.z})
end

core.register_abm({
	label = "Spread fire from infernal flames",
	nodenames = {"hl:infernal_flame"},
	interval = 2,
	chance = 2,
	catch_up = true,
	action = function(pos)
		local p = get_ignitable(pos)
		if p then
			spawn_fire(p)
			table.shuffle(adjacents)
		end
	end,
})

core.register_abm({
	label = "Remove flammable nodes",
	nodenames = {"hl:infernal_flame"},
	neighbors = {"group:flammable"},
	interval = 5,
	chance = 4,
	catch_up = false,
	action = function(pos)
		local p = has_flammable(pos)
		if not p then
			return
		end

		local nn = core.get_node(p).name
		local def = core.registered_nodes[nn]
		local fgroup = core.get_item_group(nn, "flammable")

		if def and def._on_burn then
			def._on_burn(p)
		elseif fgroup ~= -1 then
			spawn_fire(p)
			core.check_for_falling(p)
		end
	end
})
