-- Copyright (C) 2025 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
--
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X
-- T GNU         ~~==__       ~~~===___               ___===~~~      __==~~                 T
-- | PROPAGANDA        ~~== __     OSS ~~~=========~~~ CUCKS   __==~~      If you need more |
-- | DEPARTMENT               ~~~===___    BIGGEST    ___===~~~            encouragment...  |
--                                     ~~~=========~~~                     all of those men  
--                                                                         are balding       
-- |                           1. Andrew S. Tanenbaum (minix)                               |
-- |   3. Linus torvalds (linux                            2. George Neville-Neil (freeBSD) |
--                       foundation)          O /          |                                 
--        YOU?                     |         /|/     /O\ <-'    +=====================+      
-- |       o    <- consellation    '->  O    `|      \|/        | REMEMBER KIDS       |     |
-- |      /|\    price for MIT         /|\   / \      |         | LICENSE  EVERYTHING |     |
--       / | \   license users.        `|/ |~~~~~~|  / \        | UNDER    THE AGPLv3 |      
--        / \    Notice the smaller    /T\ |  #1  |~~~~~~|      +=====================+      
-- |    |~~~~~~| head               |~~~~~~|      |  #2  |        |               |         |
-- |    |  #C  |                    |  #3  |      |      |        |               |         |
-- V OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO V
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X

core.register_node("hl:reinforced_brick",
{
	description = "Reinforced bricks",
	drawtype = "normal",
	groups = {solid = 1, pickaxey = 5},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	stack_max = 64,
	_mcl_hardness = 8,
	_mcl_blast_resistance = 18,
	tiles = {"reinforced_bricks.png"}
})

core.register_node("hl:reinforced_obsidian",
{
	description = "Reinforced obsidian",
	drawtype = "normal",
	groups = {solid = 1, pickaxey = 5},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	stack_max = 64,
	_mcl_hardness = 100,
	_mcl_blast_resistance = 2400,
	tiles = {"reinforced_obsidian.png"}
})

core.register_node("hl:barbed_wire",
{
	description = "Barbed wire",
	drawtype = "mesh",
	mesh = "barbed_wire.glb",
	use_texture_alpha = "clip",
	tiles = {"barbed_wire.png"},
	paramtype = "light",
	paramtype2 = "4dir",
	sunlight_propagates = true,
	is_ground_content = false,
	groups = {shearsy_cobweb = 1, disable_jump = 1},
	damage_per_second = 2,
	move_resistance = 14,
	stack_max = 64,
	walkable = false,
	_mcl_hardness = 6,
	_mcl_shears_drop = true,
	_pathfinding_class = "DANGER_OTHER",
})

hl.define_recipe("barbed wire", {
	output = "hl:barbed_wire",
	recipe = {
		{"hl:barbed_wire_thread", "hl:barbed_wire_thread", "hl:barbed_wire_thread"},
		{"mcl_core:stick",                 "",                               "mcl_core:stick"}
	}
})

core.register_node("hl:flaming_barbed_wire",
{
	description = "Flaming barbed wire",
	drawtype = "mesh",
	mesh = "barbed_wire.glb",
	use_texture_alpha = "clip",
	tiles = {"flaming_barbed_wire.png"},
	paramtype = "light",
	paramtype2 = "4dir",
	sunlight_propagates = true,
	is_ground_content = false,
	groups = {shearsy_cobweb = 1, disable_jump = 1},
	damage_per_second = 2,
	move_resistance = 14,
	stack_max = 64,
	walkable = false,
	_mcl_hardness = 6,
	_mcl_shears_drop = true,
	-- Polyfil until mineclonia update
	_on_walk_through = function(pos, node, obj)
		mcl_burning.set_on_fire(obj, 10)
	end,
	_mcl_on_entity_inside = function(pos, node, obj)
		mcl_burning.set_on_fire(obj, 10)
	end,
	_pathfinding_class = "DANGER_OTHER",
})

mcl_mobs.mob_class.slowdown_nodes["hl:barbed_wire"] = {x = 0.2, y = 0.2, z = 0.2}
mcl_mobs.mob_class.slowdown_nodes["hl:flaming_barbed_wire"] = {x = 0.2, y = 0.2, z = 0.2}

hl.define_recipe("flaming barbed wire", {
	output = "hl:flaming_barbed_wire",
	recipe = {
		{"mcl_mobitems:blaze_powder", "mcl_mobitems:blaze_powder", "mcl_mobitems:blaze_powder"},
		{"hl:barbed_wire_thread", "hl:barbed_wire_thread", "hl:barbed_wire_thread"},
		{"mcl_core:stick",                 "",                               "mcl_core:stick"}
	}
})
