-- Copyright (C) 2025 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
--
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X
-- T GNU         ~~==__       ~~~===___               ___===~~~      __==~~                 T
-- | PROPAGANDA        ~~== __     OSS ~~~=========~~~ CUCKS   __==~~      If you need more |
-- | DEPARTMENT               ~~~===___    BIGGEST    ___===~~~            encouragment...  |
--                                     ~~~=========~~~                     all of those men  
--                                                                         are balding       
-- |                           1. Andrew S. Tanenbaum (minix)                               |
-- |   3. Linus torvalds (linux                            2. George Neville-Neil (freeBSD) |
--                       foundation)          O /          |                                 
--        YOU?                     |         /|/     /O\ <-'    +=====================+      
-- |       o    <- consellation    '->  O    `|      \|/        | REMEMBER KIDS       |     |
-- |      /|\    price for MIT         /|\   / \      |         | LICENSE  EVERYTHING |     |
--       / | \   license users.        `|/ |~~~~~~|  / \        | UNDER    THE AGPLv3 |      
--        / \    Notice the smaller    /T\ |  #1  |~~~~~~|      +=====================+      
-- |    |~~~~~~| head               |~~~~~~|      |  #2  |        |               |         |
-- |    |  #C  |                    |  #3  |      |      |        |               |         |
-- V OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO V
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X

core.register_tool("hl:flamethrower", {
	description = "Flamethrower",
	inventory_image = "flamethrower.png",
	wield_scale = {x = 1.5, y = 1.5, z = 1.5},
	on_use = function() end,
	on_secondary_use = function() end,
	on_place = function() end
})

local cumulative_time = 0
local time_threshold = 0.1
local wear_step = 1000
local wear_max = 65535 - wear_step
local player_data = {}
core.register_globalstep(function(dtime)
	cumulative_time = cumulative_time + dtime

	if cumulative_time < time_threshold then
		return
	end

	cumulative_time = cumulative_time - time_threshold

	for _, player in pairs(core.get_connected_players()) do
		local player_look = player:get_look_dir()
		local player_controls = player:get_player_control()
		local wielded_item_name = player:get_wielded_item():get_name()
		local player_inv = player:get_inventory()
		local torso_armor = player_inv:get_stack("armor", 3)

		local shot = false
		local shoot_condition = wielded_item_name == "hl:flamethrower"
				and player_controls.LMB
				and torso_armor:get_name() == "hl:flamethrower_canister"

		if shoot_condition and torso_armor:get_wear() < wear_max then

			shot = true

			if not player_data[player] then
				player_data[player] = core.sound_play(
					{
						name = "flamethrower"
					},
					{
						object = player,
						loop = true
					}
				)
			end

			hl.spawn_infernal_flame_entity(
				vector.offset(player:get_pos(), 0, 1, 0),
				vector.multiply(
					vector.rotate(
						player_look,
						vector.new(
							(math.random()) * math.pi / 12,
							(math.random() - 0.5) * math.pi / 12,
							(math.random() - 0.5) * math.pi / 12
						)
					),
					25
				)
			)

			torso_armor:add_wear(wear_step)
			player_inv:set_stack("armor", 3, torso_armor)
		elseif player_data[player] then
			core.sound_fade(player_data[player], 2, 0)
			player_data[player] = nil
		end

		if not shot and shoot_condition then
			core.sound_play(
				{
					name = "flamethrower-out"
				},
				{
					object = player
				},
				true
			)
		end
	end
end)

core.register_entity("hl:flamethrower_canister_model",
{
	initial_properties = {
		physical = false,
		pointable = false,
		visual = "mesh",
		mesh = "flamethrower_canister.glb",
		textures = {"flamethrower_canister_entity.png"},
		static_save = false,
	},
})

local canister_data = {}

function hl.add_flamethrower_canister(player)
	local obj = core.add_entity(
		player:get_pos(),
		"hl:flamethrower_canister_model"
	)

	obj:set_attach(
		player,
		"Body",
		vector.new(0, 4, 3)
	)
	canister_data[player] = obj
end

function hl.remove_flamethrower_canister(player)
	if not canister_data[player] then return end
	canister_data[player]:remove()
end

core.register_tool("hl:flamethrower_canister", {
	description = "Flamethrower canister",
	_doc_items_longdesc = "Provides fuel to flamethrowers",
	inventory_image = "flamethrower_canister.png",
	groups = {
		armor = 1,
		non_combat_armor = 1,
		armor_torso = 1,
		non_combat_torso = 1,
		mcl_armor_points = 2,
	},
	sounds = {
		_mcl_armor_equip = "mcl_armor_equip_leather",
		_mcl_armor_unequip = "mcl_armor_unequip_leather",
	},
	_repair_material = "hl:napalm_bottle",
	on_place = mcl_armor.equip_on_use,
	on_secondary_use = mcl_armor.equip_on_use,
	_mcl_armor_element = "torso",
	_mcl_armor_texture = "blank.png",

	_on_equip = function(obj, itemstack)
		hl.add_flamethrower_canister(obj)
	end,
	_on_unequip = function(obj, itemstack)
		hl.remove_flamethrower_canister(obj)
	end,
	_on_break = function(obj, itemstack)
		hl.remove_flamethrower_canister(obj)
	end
})

core.register_on_leaveplayer(function(player)
	hl.remove_flamethrower_canister(player)
end)

core.register_on_dieplayer(function(player)
	hl.remove_flamethrower_canister(player)
end)

core.register_on_joinplayer(function(player)
	if player:get_inventory():get_stack("armor", 3):get_name() == "hl:flamethrower_canister" then
		core.after(0.5, function()
			hl.add_flamethrower_canister(player)
		end)
	end
end)

hl.define_recipe("flamethrower canister", {
	output = "hl:flamethrower_canister",
	recipe = {
		{"mcl_core:iron_ingot", "mcl_core:stick", "mcl_core:iron_ingot"},
		{"mcl_core:iron_ingot", "",               "mcl_core:iron_ingot"},
		{"mcl_core:iron_ingot", "mcl_core:stick", "mcl_core:iron_ingot"}
	}
})

hl.define_recipe("flamethrower", {
	output = "hl:flamethrower",
	recipe = {
		{"mcl_core:iron_ingot", "",                    ""},
		{"mcl_dyes:black",      "mcl_core:iron_ingot", ""},
		{"",                    "mcl_lever:lever_off", "mcl_core:iron_ingot"}
	}
})
