-- Copyright (C) 2025 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
--
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X
-- T GNU         ~~==__       ~~~===___               ___===~~~      __==~~                 T
-- | PROPAGANDA        ~~== __     OSS ~~~=========~~~ CUCKS   __==~~      If you need more |
-- | DEPARTMENT               ~~~===___    BIGGEST    ___===~~~            encouragment...  |
--                                     ~~~=========~~~                     all of those men  
--                                                                         are balding       
-- |                           1. Andrew S. Tanenbaum (minix)                               |
-- |   3. Linus torvalds (linux                            2. George Neville-Neil (freeBSD) |
--                       foundation)          O /          |                                 
--        YOU?                     |         /|/     /O\ <-'    +=====================+      
-- |       o    <- consellation    '->  O    `|      \|/        | REMEMBER KIDS       |     |
-- |      /|\    price for MIT         /|\   / \      |         | LICENSE  EVERYTHING |     |
--       / | \   license users.        `|/ |~~~~~~|  / \        | UNDER    THE AGPLv3 |      
--        / \    Notice the smaller    /T\ |  #1  |~~~~~~|      +=====================+      
-- |    |~~~~~~| head               |~~~~~~|      |  #2  |        |               |         |
-- |    |  #C  |                    |  #3  |      |      |        |               |         |
-- V OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO V
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X

local gui = flow.widgets
local columns_per_row = 7

local granade_launch_power = 64

local function is_barrel_opened(meta)
	return meta:get_string("is_barrel_opened") == "1"
end

local function create_granade_selection_gui(player, stack)
	local my_gui
	local stack_meta = stack:get_meta()

	local function get_granade_elements()
		local elements = {}
		local head

		local i = 0
		for name, def in pairs(hl.granade_types) do

			if i % columns_per_row == 0 then
				if head then
					table.insert(head, gui.Spacer{})
					table.insert(elements, head)
				end
				head = gui.Hbox{}
			end

			table.insert(
				head,
				gui.ItemImageButton
				{
					item_name = name,
					label = def.description,
					w = 2,
					h = 2,
					on_event = function(player, ctx)

						local inv = player:get_inventory()

						if not core.is_creative_enabled(player:get_player_name()) then
							local found_stack
							for i, list_stack in pairs(inv:get_list("main")) do
								if list_stack:get_name() == name then
									found_stack = list_stack:take_item()
									inv:set_stack("main", i, list_stack)
								end
							end

							if not found_stack then return end
						end


						stack_meta:set_string("_granade_type", name)
						stack_meta:set_string("inventory_image", "granade_launcher_opened_loaded.png")
						player:set_wielded_item(stack)

						core.sound_play({
							name = "granade_launcher_insert_granade"
						},
						{
							object = player
						}, true)

						my_gui:close(player)
					end
				}
			)

			i = i + 1
		end

		if head and #head ~= 0 then
			table.insert(elements, head)
		end

		return elements
	end

	my_gui = flow.make_gui(function(player, ctx)
		return gui.VBox
		{
			gui.Label
			{
				label = "Pick granade type"
			},
			gui.ScrollableVBox {
				name = "granade_selection_scroll_area",
				h = 8,
				w = 16,

				unpack(get_granade_elements())
			}
		}
	end)

	return my_gui
end

local function right_click(itemstack, user, pointed_thing)
		local meta = itemstack:get_meta()
		if is_barrel_opened(meta) then
			core.sound_play({
				name = "granade_launcher_close_barrel"
			},
			{
				object = user
			}, true)

			meta:set_string("is_barrel_opened", "0")
			meta:set_string("inventory_image", "")
		else
			core.sound_play({
				name = "granade_launcher_open_barrel"
			},
			{
				object = user
			}, true)

			meta:set_string("is_barrel_opened", "1")
			if meta:get_string("_granade_type") == "" then
				meta:set_string("inventory_image", "granade_launcher_opened.png")
			else
				meta:set_string("inventory_image", "granade_launcher_opened_loaded.png")
			end
		end

		return itemstack
end

core.register_tool("hl:granade_launcher", {
	description = "Granade launcher",
	inventory_image = "granade_launcher_closed.png",
	wield_scale = {x = 2, y = 2, z = 2},
	on_use = function(itemstack, user, pointed_thing)
		local stack_meta = itemstack:get_meta()
		local is_open = is_barrel_opened(stack_meta)

		if is_open then
			create_granade_selection_gui(user, itemstack):show(user)
		else
			local type = stack_meta:get_string("_granade_type")

			if type == "" then return end

			local player_look = user:get_look_dir()

			core.sound_play({
				name = "granade_launcher_launch"
			},
			{
				object = user
			}, true)

			hl.spawn_granade(
				vector.offset(user:get_pos(), 0, 1.5, 0),
				vector.multiply(player_look, granade_launch_power),
				type,
				true
			)

			stack_meta:set_string("_granade_type", "")
		end

		return itemstack
	end,
	on_secondary_use = right_click,
	on_place = right_click,
})

hl.define_recipe("granade launcher", {
	output = "hl:granade_launcher",
	recipe = {
		{"mcl_dyes:black",     "",                   ""},
		{"mcl_core:ironblock", "mcl_core:ironblock", "mcl_trees:stripped_oak"}
	}
})
