-- Copyright (C) 2025 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
--
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X
-- T GNU         ~~==__       ~~~===___               ___===~~~      __==~~                 T
-- | PROPAGANDA        ~~== __     OSS ~~~=========~~~ CUCKS   __==~~      If you need more |
-- | DEPARTMENT               ~~~===___    BIGGEST    ___===~~~            encouragment...  |
--                                     ~~~=========~~~                     all of those men  
--                                                                         are balding       
-- |                           1. Andrew S. Tanenbaum (minix)                               |
-- |   3. Linus torvalds (linux                            2. George Neville-Neil (freeBSD) |
--                       foundation)          O /          |                                 
--        YOU?                     |         /|/     /O\ <-'    +=====================+      
-- |       o    <- consellation    '->  O    `|      \|/        | REMEMBER KIDS       |     |
-- |      /|\    price for MIT         /|\   / \      |         | LICENSE  EVERYTHING |     |
--       / | \   license users.        `|/ |~~~~~~|  / \        | UNDER    THE AGPLv3 |      
--        / \    Notice the smaller    /T\ |  #1  |~~~~~~|      +=====================+      
-- |    |~~~~~~| head               |~~~~~~|      |  #2  |        |               |         |
-- |    |  #C  |                    |  #3  |      |      |        |               |         |
-- V OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO V
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X

core.register_entity("hl:gas_mask_model", {
	initial_properties = {
		physical = false,
		pointable = false,
		visual = "mesh",
		mesh = "gas_mask.glb",
		textures = {"gas_mask_entity.png"},
		static_save = false,
	},
})

local mask_data = {}

function hl.add_gas_mask(player)
	local obj = core.add_entity(
		player:get_pos(),
		"hl:gas_mask_model"
	)

	local hud_id = player:hud_add({
		type = "image",
		name = "gas mask overlay",
		text = "gas_mask_overlay.png",
		scale = {x = 50, y = 50},
		position = {x = 0.5, y = 0.5},
		alignment = {x = 0, y = 0},
		z_index = -1
	})

	obj:set_attach(
		player,
		"Head",
		vector.new(0, 1.4, 0)
	)

	local sound_handler = core.sound_play(
		{
			name = "gas-mask-breathing",
			gain = 2
		},
		{
			loop = true,
			object = player
		}
	)

	mask_data[player] = {
		obj = obj,
		hud_id = hud_id,
		sound_handler = sound_handler
	}
end

function hl.remove_gas_mask(player)
	if not mask_data[player] then return end
	mask_data[player].obj:remove()
	player:hud_remove(mask_data[player].hud_id)
	core.sound_stop(mask_data[player].sound_handler)
	mask_data[player] = nil
end

function hl.is_player_wearing_gas_mask(player)
	return mask_data[player] ~= nil
end

core.register_tool("hl:gas_mask", {
	description = "Gas mask",
	_doc_items_longdesc = "Gives immunity to mustard gas",
	inventory_image = "gas_mask_inventory_image.png",
	groups = {
		armor = 1,
		non_combat_armor = 1,
		armor_head = 1,
		non_combat_head = 1,
		mcl_armor_points = 2,
		mcl_armor_uses = 200
	},
	sounds = {
		_mcl_armor_equip = "mcl_armor_equip_leather",
		_mcl_armor_unequip = "mcl_armor_unequip_leather",
	},
	on_place = mcl_armor.equip_on_use,
	on_secondary_use = mcl_armor.equip_on_use,
	_mcl_armor_element = "head",
	_mcl_armor_texture = "blank.png",

	_on_equip = function(obj, itemstack)
		hl.add_gas_mask(obj)
	end,
	_on_unequip = function(obj, itemstack)
		hl.remove_gas_mask(obj)
	end,
	_on_break = function(obj, itemstack)
		hl.remove_gas_mask(obj)
	end
})

core.register_on_leaveplayer(function(player)
	hl.remove_gas_mask(player)
end)

core.register_on_dieplayer(function(player)
	hl.remove_gas_mask(player)
end)

core.register_on_joinplayer(function(player)
	if player:get_inventory():get_stack("armor", 2):get_name() == "hl:gas_mask" then
		core.after(0.5, function()
			hl.add_gas_mask(player)
		end)
	end
end)

hl.define_recipe("gas mask", {
	output = "hl:gas_mask",
	recipe = {
		{"mcl_core:charcoal_lump", "mcl_core:charcoal_lump",   "mcl_core:charcoal_lump"},
		{"mcl_core:charcoal_lump", "mcl_armor:helmet_leather", "mcl_core:charcoal_lump"},
		{"mcl_core:charcoal_lump", "mcl_core:charcoal_lump",   "mcl_core:charcoal_lump"},
	}
})
