-- Copyright (C) 2025 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
--
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X
-- T GNU         ~~==__       ~~~===___               ___===~~~      __==~~                 T
-- | PROPAGANDA        ~~== __     OSS ~~~=========~~~ CUCKS   __==~~      If you need more |
-- | DEPARTMENT               ~~~===___    BIGGEST    ___===~~~            encouragment...  |
--                                     ~~~=========~~~                     all of those men  
--                                                                         are balding       
-- |                           1. Andrew S. Tanenbaum (minix)                               |
-- |   3. Linus torvalds (linux                            2. George Neville-Neil (freeBSD) |
--                       foundation)          O /          |                                 
--        YOU?                     |         /|/     /O\ <-'    +=====================+      
-- |       o    <- consellation    '->  O    `|      \|/        | REMEMBER KIDS       |     |
-- |      /|\    price for MIT         /|\   / \      |         | LICENSE  EVERYTHING |     |
--       / | \   license users.        `|/ |~~~~~~|  / \        | UNDER    THE AGPLv3 |      
--        / \    Notice the smaller    /T\ |  #1  |~~~~~~|      +=====================+      
-- |    |~~~~~~| head               |~~~~~~|      |  #2  |        |               |         |
-- |    |  #C  |                    |  #3  |      |      |        |               |         |
-- V OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO V
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X

function hl.spawn_smoke(power, smoke_volume, pos)
	core.add_particlespawner({
		amount = smoke_volume,
		collisiondetection = true,
		pos = pos,
		radius = 1,
		attract = {
			kind = "point",
			strength = {
				min = -power / 2,
				max = -power
			},
			origin = pos
		},
		vel = {
			min = vector.new(0, -0.5, 0),
			max = vector.new(0, 0, 0)
		},
		drag = {
			min = vector.new(0.2, 0.2, 0.2),
			max = vector.new(1, 1, 1)
		},
		size = {
			min = 16,
			max = 24
		},
		jitter = {
			min = vector.new(-1, -1, -1),
			max = vector.new(1, 1, 1)
		},
		exptime = {
			min = 35,
			max = 60,
		},
		texpool = {
			{name = "smoke_particle.1.png", blend = "clip"},
			{name = "smoke_particle.2.png", blend = "clip"},
			{name = "smoke_particle.3.png", blend = "clip"}
		},
		bounce = 0.5
	})
end

local mustard_gas_emissions = {}
hl.mustard_gas_damage_multiplier = 25
hl.max_concentration = 0.1
hl.mustard_gas_drag = 0.80
hl.base_mustard_spreading_speed = 0.2

function hl.spawn_mustard_gas(power, gas_volume, pos)

	core.sound_play(
		{
			name = "gas-emission"
		},
		{
			pos = pos
		},
		true
	)

	table.insert(mustard_gas_emissions, {
		pos = pos,
		radius = 0,
		power = power / 2,
		gas = gas_volume
	})
end

local mustard_step_accumulator = 0
core.register_globalstep(function(dtime)
	mustard_step_accumulator = mustard_step_accumulator + dtime

	if mustard_step_accumulator > 0.5 then
		local to_be_removed = {}
		for i, emission in pairs(mustard_gas_emissions) do
			emission.power = emission.power * hl.mustard_gas_drag * mustard_step_accumulator
			emission.radius = emission.radius + (emission.power + hl.base_mustard_spreading_speed) * mustard_step_accumulator
			local concentration = math.min(emission.gas / (0.75 * math.pi * math.pow(emission.radius, 3)), hl.max_concentration)
			-- core.debug(dump(emission), concentration)

			for obj in core.objects_inside_radius(emission.pos, emission.radius) do
				if not hl.is_player_wearing_gas_mask(obj) then
					mcl_util.deal_damage(obj, 1 * mustard_step_accumulator * concentration * hl.mustard_gas_damage_multiplier, {type = "generic"})
				end
			end

			if emission.particle_spawner then
				core.delete_particlespawner(emission.particle_spawner)
			end

			emission.particle_spawner = core.add_particlespawner({
				amount = emission.gas / 4,
				collisiondetection = true,
				pos = emission.pos,
				radius = {
					min = vector.new(0, 0, 0),
					max = emission.radius,
				},
				vel = {
					min = vector.new(0, -0.5, 0),
					max = vector.new(0, 0, 0)
				},
				drag = {
					min = vector.new(0.2, 0.2, 0.2),
					max = vector.new(1, 1, 1)
				},
				size = {
					min = 16,
					max = 24
				},
				jitter = {
					min = vector.new(-1, -1, -1),
					max = vector.new(1, 1, 1)
				},
				exptime = {
					min = 1,
					max = 5,
				},
				texpool = {
					"mustard_gas_particle.1.png",
					size = {
						x = 32,
						y = 16
					},
					blend = "clip"
				},
				bounce = 0.5
			})

			if concentration < 0.01 then
				table.insert(to_be_removed, i)
			end
		end

		if #to_be_removed > 0 then
			mustard_gas_emissions = hl.helpers.table_bulk_remove(mustard_gas_emissions, to_be_removed)
		end

		mustard_step_accumulator = 0
	end
end)
