-- Copyright (C) 2025 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
--
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X
-- T GNU         ~~==__       ~~~===___               ___===~~~      __==~~                 T
-- | PROPAGANDA        ~~== __     OSS ~~~=========~~~ CUCKS   __==~~      If you need more |
-- | DEPARTMENT               ~~~===___    BIGGEST    ___===~~~            encouragment...  |
--                                     ~~~=========~~~                     all of those men  
--                                                                         are balding       
-- |                           1. Andrew S. Tanenbaum (minix)                               |
-- |   3. Linus torvalds (linux                            2. George Neville-Neil (freeBSD) |
--                       foundation)          O /          |                                 
--        YOU?                     |         /|/     /O\ <-'    +=====================+      
-- |       o    <- consellation    '->  O    `|      \|/        | REMEMBER KIDS       |     |
-- |      /|\    price for MIT         /|\   / \      |         | LICENSE  EVERYTHING |     |
--       / | \   license users.        `|/ |~~~~~~|  / \        | UNDER    THE AGPLv3 |      
--        / \    Notice the smaller    /T\ |  #1  |~~~~~~|      +=====================+      
-- |    |~~~~~~| head               |~~~~~~|      |  #2  |        |               |         |
-- |    |  #C  |                    |  #3  |      |      |        |               |         |
-- V OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO##OO V
-- X<--  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -->X

local gui = flow.widgets

function hl.create_round_itemstack(round_name, load)
	local round_stack = ItemStack(round_name)
	local item_name = round_stack:get_name()
	if core.get_item_group(item_name, "hl_round") <= 0 then
		return false, nil
	end

	local stack_meta = round_stack:get_meta()
	if stack_meta:get("heavy_load") then
		return false, nil
	end

	stack_meta:set_string("description", string.format("1m Round (%s)", hl.get_load_name(load)))
	stack_meta:set_string("heavy_load", hl.serialize_load(load))

	return true, round_stack
end

function hl.load_round(round_stack, pos, dir)
	local item_name = round_stack:get_name()
	if core.get_item_group(item_name, "hl_round") <= 0 then
		core.debug("111")
		return false, nil
	end

	local item_def = core.registered_items[round_stack:get_name()]

	local load = hl.create_empty_load()
	local iterator = vector.copy(pos)
	local node_positions = {}

	while true do
		local node = core.get_node(iterator)

		local component_def = hl.registered_loads[node.name]
		if component_def then
			table.insert(load.components, table.copy(component_def))
			table.insert(node_positions, iterator)
			load.total_weight = load.total_weight + component_def.weight
		else
			break
		end

		iterator = iterator + dir
	end

	if #load.components == 0 then
		core.debug("PIPIPI")
		return false, nil
	end

	if #node_positions > item_def._max_components then
		core.debug("222")
		return false, nil
	end

	local stack_meta = round_stack:get_meta()
	if stack_meta:get("heavy_load") then
		core.debug("333", stack_meta:get("heavy_load"))
		return false, nil
	end

	for _, node_pos in pairs(node_positions) do
		core.remove_node(node_pos)
	end

	core.debug("444")
	return hl.create_round_itemstack(item_name, load)
end

function hl.round_maker_action(pos, node)
	local dir = core.facedir_to_dir(node.param2)
	local index
	local stack

	local meta = core.get_meta(pos)
	local inv = meta:get_inventory()
	local list = inv:get_list("main")

	if not list then
		-- I don't know why this happens, but it can happen for whatever reason
		return
	end

	for i, v in pairs(list) do
		local name = v:get_name()
		local meta = v:get_meta()
		if core.get_item_group(name, "hl_round") > 0 and not meta:get("heavy_load") then
			index = i
			stack = v
			break
		end
	end

	if not index then
		return
	end

	core.debug("ahh", pos + dir, pos, dir)
	local success, round_itemstack = hl.load_round(stack, pos + dir, dir)
	core.debug("here3", success, round_itemstack)

	if not success then
		return
	end

	inv:set_stack("main", index, round_itemstack)
end

core.register_craftitem("hl:0_5m_round",
{
	inventory_image = "0-5m-caliber-round.png",
	description = "Empty 0.5m casing",
	stack_max = 16,
	groups = {hl_round = 1},
	_max_components = 3,
	_hl_load_amount = 4
})

core.register_craftitem("hl:1m_round",
{
	inventory_image = "1m-caliber-round.png",
	description = "Empty 1m casing",
	stack_max = 1,
	groups = {hl_round = 1},
	_max_components = 8,
	_hl_load_amount = 1
})

core.register_node("hl:round_maker",
{
	description = "Round maker",
	drawtype = "normal",
	groups = {solid = 1, pickaxey = 5},
	paramtype2 = "4dir",
	sounds = mcl_sounds.node_sound_stone_defaults(),
	stack_max = 64,
	_mcl_hardness = 100,
	_mcl_blast_resistance = 2400,
	tiles = {"round-maker-side.png", "round-maker-side.png", "round-maker-side.png", "round-maker-side.png", "round-maker-head.png", "round-maker-side.png"},

	on_construct = function(pos)
		local meta = core.get_meta(pos)
		local inv = meta:get_inventory()
		inv:set_size("main", 4)
	end,

	after_dig_node = function(pos, node, old_meta)
		for _, stack in pairs(old_meta.inventory["main"]) do
			core.add_item(pos, stack)
		end
	end,

	allow_metadata_inventory_put = function(pos, from_list, from_index, stack, to_index, count, player)
		local item_name = stack:get_name()
		local def = core.registered_items[item_name]

		if core.get_item_group(item_name, "hl_round") <= 0 then
			return 0
		end

		return def._hl_load_amount
	end,

	on_rightclick = function(pos, node, clicker)
		local my_gui

		my_gui = flow.make_gui(function(player, ctx)
			return gui.VBox 
			{
				gui.Label
				{
					label = "Round maker"
				},
				flow_extras.List
				{
					inventory_location = string.format("nodemeta:%s,%s,%s", pos.x, pos.y, pos.z),
					list_name = "main",
					bgimg = "mcl_formspec_itemslot.png^bullet_inventory_overlay.png",
					w = 2,
					h = 2,
				},
				flow_extras.List
				{
					inventory_location = "current_player",
					list_name = "main",
					bgimg = "mcl_formspec_itemslot.png",
					w = 9,
					h = 3,
					starting_item_index = 9
				},
				flow_extras.List
				{
					inventory_location = "current_player",
					list_name = "main",
					bgimg = "mcl_formspec_itemslot.png",
					w = 9,
					h = 1,
				}
			}
		end)

		my_gui:show(clicker)
	end,

	_mcl_redstone = {
		update = function(pos, node)
			if mcl_redstone.get_power(pos) > 0 then
				hl.round_maker_action(pos, node)
			end
		end
	}
})
