-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

local InlineLua = require("language_constructs.inline_lua")

minetest.register_privilege("lush_inline_lua",
{
	description = "whether the player can execute lua code within lush\n IMPORTANT!!! a player with this privilage can brick the server, dupe items and basically anything he wants",
	give_to_singleplayer = true
})

local old_eval = InlineLua.evaluate
InlineLua.evaluate = function(self, context)
	if minetest.check_player_privs(context.env:get("player"), {["lush_inline_lua"] = true}) then
		return old_eval(self, context)
	else
		error("you dont have privilages to execute lua code")
	end
end

return InlineLua
