-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

-- this is a file containing definitions of asserts/matchers
-- for the "busted" testing framework

local assert = require("luassert")
local inspect = require("inspect")

-- {{{ asserts

local function has_property(state, arguments)
	local property = arguments[1]
	local table = arguments[2]
	for key, value in pairs(table) do
		if key == property then
			return true
		end
	end

	return false
end

local function has_properties_equaling(state, arguments)
	local expected_properties = arguments[1]
	local t = arguments[2]

	if type(expected_properties) ~= "table" or type(table) ~= "table" then error("invalid arguments") end

	for key, value in pairs(expected_properties) do
		if t[key] ~= value then
			print("invalid property: \n expected: \n", key, "=", value, "\npassed: \n", key , "=", t[key])
			if type(t[key]) == "table" then
				return has_properties_equaling(nil, {t[key], value})
			else
				return false
			end
		end
	end

	return true
end

assert:register("assertion", "has_property", has_property)
assert:register("assertion", "has_properties_equaling", has_properties_equaling)

-- }}}

-- {{{ matchers

local function match_has_property(state, arguments)
	local property = arguments[1]
	return function(value)
		if type(value) ~= "table" then return false end


		for k, v in pairs(value) do
			if k == property then
				return true
			end
		end

		return false
  end
end

local function has_property_equaling(state, arguments)
	local property = arguments[1]
	local expected_property_value = arguments[2]
	return function(value)
		if type(value) ~= "table" then return false end

		for k, v in pairs(value) do
			if k == property and v == expected_property_value then
				return true
			end
		end

		return false
  end
end

--- only shallow checking
local function same(state, arguments)
	local expected_table = arguments[1]
	return function(value)
		if type(value) ~= "table" then print("not a table") end
		if type(value) ~= "table" then return false end

		for k, v in pairs(value) do
			if expected_table[k] ~= v then
				print("INVALID", k, v)
				return false
			end
		end

		return true
  end
end

-- for some reason, these dont return false when a table dosent have the property, instead it errors in some random luaassert script, and i dont know why
-- whatever though
assert:register("matcher", "has_property", match_has_property)
assert:register("matcher", "has_property_equaling", has_property_equaling)
assert:register("matcher", "same", same)

-- }}}
