-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

require("tests/busted_definitions")
local inspect = require("inspect")

describe("LanguageConstructs_TableExpression class",
function()
	local TableExpression = require("language_constructs.table_expression")
	local ShellContext = require("shell_context")
	local ParserContext = require("parser_context")
	local shell_context_instance
	local parser_context_instance
	local table_expression_instance

	before_each(
	function()
		shell_context_instance = ShellContext:new()
		parser_context_instance = ParserContext:new()
		table_expression_instance = TableExpression:new()
	end)

	describe("parses correctly: ",
	function()

		it("when given a single element",
		function()
			parser_context_instance.text = "[name=value]"

			table_expression_instance:parse(parser_context_instance)

			assert.equals("name", table_expression_instance.key_container[1]:evaluate(shell_context_instance))
			assert.equals("value", table_expression_instance.value_container[1]:evaluate(shell_context_instance))

			assert.equals(13, parser_context_instance.character_index)
		end)

		it("when given a multiple elements",
		function()
			parser_context_instance.text = "[name=value, name2=value2]"

			table_expression_instance:parse(parser_context_instance)

			assert.equals("name", table_expression_instance.key_container[1]:evaluate(shell_context_instance))
			assert.equals("value", table_expression_instance.value_container[1]:evaluate(shell_context_instance))

			assert.equals("name2", table_expression_instance.key_container[2]:evaluate(shell_context_instance))
			assert.equals("value2", table_expression_instance.value_container[2]:evaluate(shell_context_instance))

			assert.equals(27, parser_context_instance.character_index)
		end)

		it("when given a multiple elements with excessive whitespaces",
		function()
			parser_context_instance.text = "[ name = value , name2 = value2 ]"

			table_expression_instance:parse(parser_context_instance)

			assert.equals("name", table_expression_instance.key_container[1]:evaluate(shell_context_instance))
			assert.equals("value", table_expression_instance.value_container[1]:evaluate(shell_context_instance))

			assert.equals("name2", table_expression_instance.key_container[2]:evaluate(shell_context_instance))
			assert.equals("value2", table_expression_instance.value_container[2]:evaluate(shell_context_instance))

			assert.equals(34, parser_context_instance.character_index)
		end)
	end)
end)
