-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

--- @classmod LanguageConstruct_SingleQuoteString
--	Describes a string enclodes in single quotes, which is a literal string that supports no escape sequences

local SingleQuoteString =
{
	instance_of = "LanguageConstruct_SingleQuoteString",
}

SingleQuoteString.__index = SingleQuoteString

function SingleQuoteString:new(t)
	if not t then
		t = {}
	end

	self = setmetatable(
	{
		text = t.text or ""
	}, SingleQuoteString)

	return self
end

function SingleQuoteString:evaluate(context)
	-- {{{ type checking
	if type(self.text) ~= "string" then error("self.text should be of type string. instead of " .. type(self.text)) end
	-- }}}

	return self.text
end

function SingleQuoteString:parse(parser_context)
	-- {{{ type checking
	if parser_context.instance_of ~= "ParserContext" then error("parser_context should be an instance of ParserContext. instead of " .. parser_context.instance_of) end
	-- }}}

	parser_context:advance()

	-- state: '*

	local start_character_index = parser_context.character_index

	parser_context:skip_until(
	{
		["'"] = true
	})

	self.text = string.sub(parser_context.text, start_character_index, parser_context.character_index - 1)

	-- state: '<text>*

	parser_context:advance()

	-- state: '<text>'*

end

return SingleQuoteString
