-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

--- @classmod LanguageConstruct_NumberLiteral
--	describes a numeric expression

local NumberLiteral =
{
	instance_of = "LanguageConstruct_NumberLiteral",
}

NumberLiteral.__index = NumberLiteral

function NumberLiteral:new(t)
	t = t or {}

	-- {{{ type checking
	if type(t) ~= "table" then error("t should be of type table. instead of " .. type(t)) end
	if t.number and type(t.number) ~= "number" then error("t.number should be of type number. instead of " .. type(t.number)) end
	-- }}}
	self = setmetatable(
	{
		value = t.value
	}, NumberLiteral)

	return self
end

function NumberLiteral:evaluate(context)
	-- {{{ type checking
	if context.instance_of ~= "ShellContext" then error("context should be an instance of ShellContext. instead of " .. context.instance_of) end
	-- }}}

	return self.value
end

function NumberLiteral:parse(parser_context, terminator_set)
	NumberLiteral = NumberLiteral or require("language_constructs.number_literal")

	local start_index = parser_context.character_index
	parser_context:skip_until(terminator_set)

	-- using lua's builtin parsing functionality
	-- why work hard when you can work smart?
	self.value = tonumber(string.sub(parser_context.text, start_index, parser_context.character_index - 1))

	if self.value == nil then
		error("invalid number format")
	end

end

return NumberLiteral
