-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

local CommandInvocation = require("language_constructs.command_invocation")
local Command = require("command")
local DatatypeValidator = require("datatype_validator")
local helpers = require("helpers")

local old_evaluate = CommandInvocation.evaluate
CommandInvocation.evaluate = function(self, context)
	local evaluated_name = self.name:evaluate(context)

	if Command.is_name_registered(evaluated_name) then
		old_evaluate(self, context)
	elseif minetest.registered_chatcommands[evaluated_name] then
		local params_table = {}
		local params = ""
		local evaluated_value
		local success
		local stdout

		for _, v in pairs(self.args) do
			if v.instance_of == "LanguageConstruct_SelectorExpression" then
				-- special case for selector expression because it returns a TypedList of matched objects
				evaluated_value = v:evaluate(context):get(1)
			else
				evaluated_value = v:evaluate(context)
			end

			evaluated_value = DatatypeValidator:cast_to(evaluated_value, "string")

			table.insert(params_table, evaluated_value)
		end

		params = table.concat(params_table, " ")

		minetest.log("\"" .. evaluated_name .. "\" is not a native lush command, using compatibility layer\npassed params: \"" .. params .. "\"")

		success, stdout = minetest.registered_chatcommands[evaluated_name].func(context.env:get("name"), params)

		if success then
			context.exit_status = 0
			-- minetest.log("COMMAND RETURNED " .. dump(stdout))
			-- minetest.log("return value " .. dump(stdout))
			-- minetest.log("current datatype " .. dump(context.stdout.current_datatype))
			if stdout then
				context.stdout:concat(helpers.string_split(stdout, "\n"))
			end
		else
			-- minetest.log("command name provided: \"" .. evaluated_name .. "\"")
			-- minetest.log("name provided: \"" .. context.env:get("name") .. "\"")
			-- minetest.log("params provided: \"" .. params .. "\"")
			-- minetest.log("success provided: \"" .. dump(success) .. "\"")
			error(stdout)
		end
	else
		error("command not found: " .. evaluated_name)
	end
end


return CommandInvocation
