-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

minetest.register_privilege("lush_doas",
{
	description = "can execute commands as other users",
	give_to_admin = true
})

lush.Command:new(
{
	name = "doas",
	description = "executes a shell as another player",
	privs = {lush_doas = true},
	arguments = 
	{
		{
			name = "player",
			type = "player_name",
			single = true,
		},
		{
			name = "shell_code",
			type = "string",
			single = true,
		},
	},
	callback = function(context, args, options)
		lush.Parser.run_shell(args.shell_code, 
		lush.ShellContext:new({env = lush.player_environments[args.player], stdout = context.stdout}), true)
	end,
})

lush.Command:new(
{
	name = "su",
	description = "pretend to be other players when executing commands",
	privs = {lush_doas = true},
	arguments = 
	{
		{
			name = "player",
			type = "player_name",
			single = true,
		},
	},
	callback = function(context, args, options)
		if not context.env.volatile_parameters["su_previous"] then
			context.env.volatile_parameters["su_previous"] = context.env:get("name")
		end

		-- not using set(), this is because these members are read only
		context.env.volatile_parameters["name"] = args.player
	end,
})


lush.Command:new(
{
	name = "sb",
	description = "stops pretending to be another user",
	arguments = {},
	callback = function(context, args, options)
		if context.env:get("su_previous") then
			context.env.volatile_parameters["name"] = context.env.volatile_parameters["su_previous"]
			context.env.volatile_parameters["su_previous"] = nil
		else
			error("you arent pretending to be another user")
		end
	end,
})
