-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

-- this file contains commandas for warping

-- i really dont like how long the names get
-- but i dont have a solution for now

-- table:
-- key - string name of player
-- value - table with requests for that player
-- table has the requesting player's name as the key
-- and a job for cancelling the request as the value
local teleport_requests = {}

minetest.register_privilege("tpr",
{
	description = "whether can send and accept teleport requests",
	give_to_admin = true
})

lush.Command:new(
{
	name = "tpr",
	description = "sends a teleport request to a player",
	privs = {tpr = true},
	arguments =
	{
		{
			name = "name",
			type = "player_name",
			single = true
		}
	},
	callback = function(context, args, options)
		teleport_requests[args.name] = teleport_requests[args.name] or {}

		-- when overwriting an old request, stop its expiration timer
		if teleport_requests[args.name][context.env:get("name")] then
			teleport_requests[args.name][context.env:get("name")]:cancel()
		end

		teleport_requests[args.name][context.env:get("name")] = minetest.after(minetest.settings:get("lush_tpr_timeout") or 60, function()
			teleport_requests[args.name][context.env:get("name")] = nil
			minetest.chat_send_player(string.format("teleport request from %s has expired", context.env:get("name")))
		end)

		minetest.chat_send_player(args.name, string.format("%s sent you a teleport request. type /tpa to accept", context.env:get("name")))
	end,
})

-- @todo implement optional arguments
lush.Command:new(
{
	name = "tpa",
	description = "accept a teleport request from a player",
	privs = {tpr = true},
	arguments =
	{
		{
			name = "name",
			type = "player_name",
			single = true
		}
	},
	callback = function(context, args, options)
		if teleport_requests[context.env:get("name")] and teleport_requests[context.env:get("name")][args.name] then
			teleport_requests[context.env:get("name")][args.name]:cancel()
			teleport_requests[context.env:get("name")][args.name] = nil

			minetest.get_player_by_name(context.env:get("name")):set_pos(minetest.get_player_by_name(args.name):get_pos())
		else
			error(string.format("no teleport requests from %s", args.name))
		end
	end,
})
