-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

--- @classmod LanguageConstruct_NumericExpression
--	describes a numeric expression

local NumberLiteral
local inspect = require("inspect")

local NumericExpression =
{
	instance_of = "LanguageConstruct_NumericExpression",
}

NumericExpression.__index = NumericExpression

function NumericExpression:new()
	self = setmetatable(
	{
		expression = nil
	}, NumericExpression)

	return self
end

function NumericExpression:evaluate(context)
	-- {{{ type checking
	if context.instance_of ~= "ShellContext" then error("context should be an instance of ShellContext. instead of " .. context.instance_of) end
	-- }}}

	return self.expression:evaluate(context)
end

function NumericExpression:parse(parser_context, terminator_set)
	NumberLiteral = NumberLiteral or require("language_constructs.number_literal")

	self.expression = NumberLiteral:new()

	self.expression:parse(parser_context, terminator_set)
end

return NumericExpression
