-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

describe("ShellContext class: ",
function()
	local ShellContext
	local Env
	local TypedList
	local instance

	setup(
	function()
		ShellContext = require("shell_context")
		Env = require("env")
		TypedList = require("typed_list")
	end)

	it("dosent error during construction with correct parameters",
	function()
		assert.has_no.errors(function() ShellContext:new() end)
	end)

	it("errors when wrong parameters are passed to new()",
	function()
		assert.has_error(function() ShellContext:new("string") end)
	end)

	describe("all members are correcly set by new(): ",
	function()
		local definition_table

		before_each(
		function()
			definition_table =
			{
				stdin = TypedList:new(),
				stdout = TypedList:new(),
				env = Env:new(),
				stderr = "error message",
				exit_status =  1
			}
			instance = ShellContext:new(definition_table)
		end)

		it("stdin",
		function()
			assert.is.equal(definition_table.stdin, instance.stdin)
		end)

		it("stdout",
		function()
			assert.is.equal(definition_table.stdout, instance.stdout)
		end)

		it("stderr",
		function()
			assert.is.equal(definition_table.stderr, instance.stderr)
		end)

		it("env",
		function()
			assert.is.equal(definition_table.env, instance.env)
		end)

		it("exit_status",
		function()
			assert.is.equal(definition_table.exit_status, instance.exit_status)
		end)
	end)
end)
