-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

require("tests/busted_definitions")
local inspect = require("inspect")

describe("LanguageConstruct_InlineLua class: ",
function()
	local InlineLua = require("language_constructs.inline_lua")
	local ParserContext = require("parser_context")
	local helpers = require("helpers")
	local inline_lua_instance
	local parser_context_instance

	before_each(
	function()
		inline_lua_instance = InlineLua:new()
		parser_context_instance = ParserContext:new()
	end)

	describe("parses correctly: ",
	function()

		it("simple code",
		function()
			parser_context_instance.text = [[`return "string"`]]

			inline_lua_instance:parse(parser_context_instance)

			assert.equals("string", inline_lua_instance.chunk())

			assert.equals(18, parser_context_instance.character_index)
		end)

		it("escaped backticks works",
		function()
			parser_context_instance.text = [[`return "\`"`]]

			inline_lua_instance:parse(parser_context_instance)

			assert.equals("`", inline_lua_instance.chunk())

			assert.equals(14, parser_context_instance.character_index)
		end)

		it("supports new lines",
		function()
			parser_context_instance.text = [[`local var = "string" \n return var`]]

			inline_lua_instance:parse(parser_context_instance)

			assert.equals("string", inline_lua_instance.chunk())

			assert.equals(37, parser_context_instance.character_index)
		end)
	end)

	-- not adding a section for evaluating, because its basically already done in the parsing part
end)
