-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

require("tests/busted_definitions")

describe("LanguageConstructs_ParameterAsignment class: ",
function()
	local ParameterAsignment = require("language_constructs.parameter_asignment")
	local ParserContext = require("parser_context")
	local ShellContext = require("shell_context")
	local helpers = require("helpers")
	local parser_context_instance
	local shell_context_instance
	local parameter_asignment_instance

	before_each(
	function()
		parser_context_instance = ParserContext:new()
		shell_context_instance = ShellContext:new()
		parameter_asignment_instance = ParameterAsignment:new()
	end)

	it("parses correctly when given a simple asignment",
	function()
		parser_context_instance.text = "parameter=value"

		parameter_asignment_instance:parse(parser_context_instance, helpers.white_chars_set)
		parameter_asignment_instance:evaluate(shell_context_instance)

		assert.equals(16, parser_context_instance.character_index)
		assert.equals("value", shell_context_instance.env:get("parameter"))
	end)
end)
