-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

local ForLoop = require("language_constructs.for_loop")

local is_enabled = minetest.settings:get_bool("lush_loops")
local max_frustration = minetest.settings:get_bool("lush_max_loop_iterations") or 10000

-- setting default value
if is_enabled == nil then
	is_enabled = true
end

if is_enabled then
	local old_eval = ForLoop.evaluate
	ForLoop.evaluate = function(self, context)
		if minetest.check_player_privs(context.env:get("name"), {lush_loops = true}) then
			return old_eval(self, context, max_frustration)
		else
			error("'lush_loops' privilege is required to use for loops")
		end
	end

else
	ForLoop = {} -- clearing everything

	function ForLoop.parser(parser_context)
		error("for loops are disabled on this server")
	end

	function ForLoop.new(self, t)
		error("for loops are disabled on this server")
	end
end

return ForLoop
