-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

--- @classmod LanguageConstruct_SelectorExpression
--	describes a vector

local inspect = require("inspect")
local helpers = require("helpers")
local selector = require("selector")
local TableExpression
local TypedList


local SelectorExpression =
{
	instance_of = "LanguageConstruct_SelectorExpression",
}

SelectorExpression.__index = SelectorExpression

function SelectorExpression:new(t)
	t = t or {}
	self = setmetatable(
	{
		preset = t.preset or {},
		explicit_parameters = t.explicit_parameters or {}
	}, SelectorExpression)

	return self
end

function SelectorExpression:evaluate(context)
	-- {{{ type checking
	if context.instance_of ~= "ShellContext" then error("context should be an instance of ShellContext. instead of " .. context.instance_of) end
	-- }}}

	TypedList = TypedList or require("typed_list")

	local evaluated_explicit_params
	if self.explicit_parameters.instance_of == "LanguageConstruct_TableExpression" then
		evaluated_explicit_params = self.explicit_parameters:evaluate(context)
	end

	local expanded_list = selector.expand(self.preset, evaluated_explicit_params, context)
	local output = TypedList:new()

	output:concat(expanded_list)

	return output
end

-- @fixme add infinite ranges support
-- the state comments dont include white spaces because it would be too verbose to be useful
function SelectorExpression:parse(parser_context)
	-- {{{ type checking
	if parser_context.instance_of ~= "ParserContext" then error("parser_context should be an instance of ParserContext. instead of " .. parser_context.instance_of) end
	-- }}}

	TableExpression = TableExpression or require("language_constructs.table_expression")

	local char = parser_context:consume()

	if char ~= "@" then
		error("selectors are supposed to start with \"@\", instead of " .. char)
	end

	char = parser_context:consume()
	self.preset = char

	if not self.preset then
		error("invalid selector")
	end

	char = parser_context:peek()

	if char == "[" then
		self.explicit_parameters = TableExpression:new()
		self.explicit_parameters:parse(parser_context)
	end

end

return SelectorExpression
