-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

local Env = require("env")
local inspect = require("inspect")

-- dictionary
-- where the key is a name of the player
-- and the value is an Env instance
lush.player_environments = {}

-- dictionary
-- where the key is a name of the player
-- and the value is a dictionary of parameters
local player_parameters = lush.Storage.load("player_parameters", {})

Env.modify_on_player_join =
{
	function(env, name, last_login)
		env:set("name", name, true, true)
	end,

	function(env, name, last_login)
		env:set("pos", function(self)
			return minetest.get_player_by_name(self:get("name")):get_pos()
		end, true, true)
	end,
}

minetest.register_on_mods_loaded(function()
    minetest.register_on_joinplayer(function(player, last_login)
		local name = player:get_player_name()

		lush.player_environments[name] = Env:new({parameters = player_parameters[name] or {}})
		lush.player_environments[name]:inherit(lush.global_env)

		for i, v in pairs(Env.modify_on_player_join) do
			v(lush.player_environments[name], name, last_login)
		end
    end)
end)

local old_set = Env.set

Env.set = function(self, key, value, read_only, volatile)
	if type(value) == "userdata" or (type(value) == "table" and value.instance_of == "TypedList" 
		and (value.type == "player" or value.type == "objectref")) then
		error("userdata (like ObjectRefs) are not allowed in lush environments")
	end

	old_set(self, key, value, read_only, volatile)
end

return Env
