-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

--- @classmod ShellContext <br>
-- this module defines the ShellContext class <br>
-- a structure that acts like a protocol to fallicitate dataflow from <br>
-- different commands or the shell itself

local ShellContext = require("shell_context")

local old_new = ShellContext.new

function ShellContext:new(t)
	t = t or {}
	self = old_new(self, t)
	self.privilege_cache = t.privilege_cache or {}
	return self
end

return ShellContext
