-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

require("tests.busted_definitions")
require("tests.command_definitions")
local inspect = require("inspect")

describe("LanguageConstructs_ForLoop class",
function()
	local ForLoop = require("language_constructs.for_loop")
	local ShellContext = require("shell_context")
	local ParserContext = require("parser_context")
	local helpers = require("helpers")
	local shell_context_instance
	local parser_context_instance
	local for_loop_instance
	local evaluated_table

	before_each(
	function()
		shell_context_instance = ShellContext:new()
		parser_context_instance = ParserContext:new()
		for_loop_instance = ForLoop:new()
	end)

	it("parses basic for loop",
	function()
		parser_context_instance.text = [[for i in <0:100> do; echo $i; end]]

		for_loop_instance:parse(parser_context_instance)
		for_loop_instance:evaluate(shell_context_instance)

		assert.equals(34, parser_context_instance.character_index)

		for i = 0, 100 do
			assert.equals(i, shell_context_instance.stdout:get(i + 1))
		end
	end)

	it("errors if the iteration amount exceeds the maximum",
	function()
		parser_context_instance.text = [[for i in <0:11> do; echo $i; end]]

		for_loop_instance:parse(parser_context_instance)

		assert.equals(33, parser_context_instance.character_index)
		assert.errors(function() for_loop_instance:evaluate(shell_context_instance, 10) end)
	end)
end)
