-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

require("tests/busted_definitions")

describe("LanguageConstructs_NumberLiteral class: ",
function()
	local NumberLiteral = require("language_constructs.number_literal")
	local ParserContext = require("parser_context")
	local helpers = require("helpers")
	local parser_context_instance
	local number_literal_instance

	before_each(
	function()
		parser_context_instance = ParserContext:new()
		number_literal_instance = NumberLiteral:new()
	end)

	describe("parses correctly: ",
	function()

		it("when given a single digit number",
		function()
			parser_context_instance.text = "1"

			number_literal_instance:parse(parser_context_instance, helpers.white_chars_set)

			assert.equals(1, number_literal_instance.value)

			assert.equals(2, parser_context_instance.character_index)
		end)

		it("when given a natural number",
		function()
			parser_context_instance.text = "100"

			number_literal_instance:parse(parser_context_instance, helpers.white_chars_set)

			assert.equals(100, number_literal_instance.value)

			assert.equals(4, parser_context_instance.character_index)
		end)

		it("when given negative number",
		function()
			parser_context_instance.text = "-100"

			number_literal_instance:parse(parser_context_instance, helpers.white_chars_set)

			assert.equals(-100, number_literal_instance.value)

			assert.equals(5, parser_context_instance.character_index)
		end)

		it("when given numbers with decnimal spaces",
		function()
			parser_context_instance.text = "-100.001"

			number_literal_instance:parse(parser_context_instance, helpers.white_chars_set)

			assert.equals(-100.001, number_literal_instance.value)

			assert.equals(9, parser_context_instance.character_index)
		end)

		it("ends parsing when encountering a terminator",
		function()
			parser_context_instance.text = "100 200 300"

			number_literal_instance:parse(parser_context_instance, helpers.white_chars_set)

			assert.equals(100, number_literal_instance.value)

			assert.equals(4, parser_context_instance.character_index)
		end)
	end)
end)
