-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

--- @classmod Interruption <br>
-- this module defines the Interruption class <br>
-- a class for interrupting the shell's execution and storing information necessary to restart execution


local Interruption =
{
	instance_of = "Interruption"
}

Interruption.__index = Interruption

--- constructor
-- @tab t definition table with matching keys as the class
-- @treturn Env the newly created Env instance
function Interruption:new(t)
	t = t or {}

	-- {{{ type checking
	if type(t) ~= "table" then error("t should be of type table. instead of " .. type(t)) end
	if t.stdin and t.stdin.instance_of ~= "TypedList" then error("t.stdin should be an instance of TypedList. instead of " .. t.stdin.instance_of) end
	if t.stdout and t.stdout.instance_of ~= "TypedList" then error("t.stdout should be an instance of TypedList. instead of " .. t.stdout.instance_of) end
	if t.stderr and type(t.stderr) ~= "string" then error("t.stderr should be of type string. instead of " .. type(t.stderr)) end
	if t.env and t.env.instance_of ~= "Env" then error("env should be an instance of Env. instead of " .. self.env.instance_of) end
	if t.exit_status and type(t.exit_status) ~= "number" then error("t.exit_status should be of type number. instead of " .. type(t.exit_status)) end
	-- }}}

	self = setmetatable(
	{
		-- shell_context = t.shell_context or {},
		-- shell = t.parse_tree or {},
		-- action_index = t.action_index or {},
		callbacks = t.callbacks or {}
	}, Interruption)

	return self
end

function Interruption:register_callback(func)
	table.insert(self.callbacks, func)
end

function Interruption:stop()
	for _, func in pairs(self.callbacks) do
		func(self)
	end
end

return Interruption
