-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

-- this file contains definitions of commands useful for testing

local Command = require("command")
local inspect = require("inspect")
require("type_definitions")

Command:new(
{
	name = "echo",
	allowed_options = {},
	callback = function(context, args, options)
		for i, v in pairs(args) do
			table.insert(context.stdout.container, v)
		end
	end,
	privs = {},
	description = "prints arguments to STDIN",
	params = "example arg ..."
})

Command:new(
{
	name = "append",
	allowed_options = {["h"] = false},
	callback = function(context, args, options)
		if #context.stdin.container == 0 then
			error("pipe is empty")
		end

		for i, v in pairs(context.stdin.container) do
			context.stdout:push(v .. args[1])
		end
	end,
	privs = {["shout"] = true, ["interact"] = true},
	description = "this is an example",
	params = "example arg ..."
})

Command:new(
{
	name = "set",
	allowed_options = {},
	callback = function(context, args, options)
		context.env:set(args[1], context.stdin:get(1))
	end,
	privs = {},
	description = "sets the given parameter to the value of STDIN",
	params = "example arg ..."
})

Command:new(
{
	name = "exit",
	description = "exits with the specified exit code",
	arguments =
	{
		{
			name = "exit_status",
			type = "number",
			single = true
		}
	},
	callback = function(context, args, options)
		if args.exit_status ~= 0 then
			error()
		end
	end,
})
