-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

require("tests/busted_definitions")
local inspect = require("inspect")

describe("LanguageConstructs_NumericExpression class",
function()
	local NumericExpression = require("language_constructs.numeric_expression")
	local ShellContext = require("shell_context")
	local ParserContext = require("parser_context")
	local helpers = require("helpers")
	local shell_context_instance
	local parser_context_instance
	local numeric_expression_instance
	local evaluated_table

	before_each(
	function()
		shell_context_instance = ShellContext:new()
		parser_context_instance = ParserContext:new()
		numeric_expression_instance = NumericExpression:new()
	end)

	describe("evaluates correctly",
	function()
		it("parses basic numbers",
		function()
			parser_context_instance.text = [[100]]

			numeric_expression_instance:parse(parser_context_instance, helpers.white_chars_set)

			assert.equals(4, parser_context_instance.character_index)
			assert.equals(100, numeric_expression_instance:evaluate(shell_context_instance))
		end)

		it("parses negative numbers",
		function()
			parser_context_instance.text = [[-100]]

			numeric_expression_instance:parse(parser_context_instance, helpers.white_chars_set)

			assert.equals(5, parser_context_instance.character_index)
			assert.equals(-100, numeric_expression_instance:evaluate(shell_context_instance))
		end)

		it("parses floating point numbers",
		function()
			parser_context_instance.text = [[100.5]]

			numeric_expression_instance:parse(parser_context_instance, helpers.white_chars_set)

			assert.equals(6, parser_context_instance.character_index)
			assert.equals(100.5, numeric_expression_instance:evaluate(shell_context_instance))
		end)

		it("stops parsing after encountering a character in the terminator set",
		function()
			parser_context_instance.text = [[100.5 ]]

			numeric_expression_instance:parse(parser_context_instance, helpers.white_chars_set)

			assert.equals(6, parser_context_instance.character_index)
			assert.equals(100.5, numeric_expression_instance:evaluate(shell_context_instance))
		end)
	end)
end)
