-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

require("tests/busted_definitions")
local inspect = require("inspect")

describe("LanguageConstruct_SingleString class:",
function()
	local SingleQuoteString = require("language_constructs.single_quote_string")
	local ShellContext = require("shell_context")
	local ParserContext = require("parser_context")
	local shell_context_instance
	local parser_context_instance
	local single_quote_string_instance

	before_each(
	function()
		shell_context_instance = ShellContext:new()
		parser_context_instance = ParserContext:new()
		single_quote_string_instance = SingleQuoteString:new()
	end)

	describe("evaluates correctly",
	function()

		it("when given a simple string",
		function()
			single_quote_string_instance.text = "string"

			assert.equals("string", single_quote_string_instance:evaluate(shell_context_instance))
		end)
	end)

	describe("parses correctly",
	function()

		it("when given a normal string",
		function()
			parser_context_instance.text = [['string']]

			single_quote_string_instance:parse(parser_context_instance)

			assert.equals("string", single_quote_string_instance.text)
		end)

		it("when given an empty string",
		function()
			parser_context_instance.text = [['']]

			single_quote_string_instance:parse(parser_context_instance)

			assert.equals("", single_quote_string_instance.text)
		end)
	end)

	describe("members are correctly set by constructor: ",
	function()
		it("elements",
		function()
			single_quote_string_instance = SingleQuoteString:new({text = "string"})

			assert.equals("string", single_quote_string_instance.text)
		end)

		it("instance_of",
		function()
			single_quote_string_instance = SingleQuoteString:new()

			assert.equals("LanguageConstruct_SingleQuoteString", single_quote_string_instance.instance_of)
		end)
	end)

end)
