-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

-- This mod is currently WIP because functions are not implemented yet in lush

-- lush.Command:new(
-- {
-- 	name = "await",
-- 	description = "stops execution until an event happens",
-- 	privs = {tpr = true},
-- 	arguments =
-- 	{
-- 		{
-- 			rule_type = "terminal"
-- 			name = "event",
-- 			value = 
-- 			{
-- 				join_player = true, mods_loaded = true, shutdown = true, 
-- 				place_node = true, dig_node = true, punch_node = true,
-- 				new_player = true, punch_player = true, die_player = true,
-- 				respawn_player = true, chat_message = true,
-- 			}
-- 		}
-- 	},
-- 	callback = function(context, args, options)
-- 		teleport_requests[args.name] = teleport_requests[args.name] or {}
--
-- 		-- when overwriting an old request, stop its expiration timer
-- 		if teleport_requests[args.name][context.env:get("name")] then
-- 			teleport_requests[args.name][context.env:get("name")]:cancel()
-- 		end
--
-- 		teleport_requests[args.name][context.env:get("name")] = minetest.after(minetest.settings:get("lush_tpr_timeout") or 60, function()
-- 			teleport_requests[args.name][context.env:get("name")] = nil
-- 			minetest.chat_send_player(string.format("teleport request from %s has expired", context.env:get("name")))
-- 		end)
--
-- 		minetest.chat_send_player(args.name, string.format("%s sent you a teleport request. type /tpa to accept", context.env:get("name")))
-- 	end,
-- })

local on_mods_loaded_callback = {}

core.register_on_mods_loaded(function()
	for _, entry in pairs(on_mods_loaded_callback) do
		entry.callback(entry.ctx, {})
	end
end)

lush.Command:new(
{
	name = "register_hook",
	description = "registers a hook to be executed at a given event",
	privs = {server = true},
	arguments =
	{
		{
			rule_type = "terminal",
			name = "event",
			value =
			{
				on_load = true,
			}
		},
		{
			name = "callback",
			type = "function",
			single = true
		}
	},
	callback = function(ctx, args, options)
		local shell_ctx = lush.ShellContext:new()
		shell_ctx.env:inherit(ctx.env)
		shell_ctx.privilege_cache = ctx.privilege_cache
		table.insert(on_mods_loaded_callback,
		{
			ctx = shell_ctx,
			callback = args.callback
		})
	end
})

local control_callbacks = {}

core.register_globalstep(function()
	for _, player in pairs(core.get_connected_players()) do
		local name = player:get_player_name()
		local entries = control_callbacks[name]
		local controls = player:get_player_control()

		if entries then
			for _, entry in pairs(entries) do
				-- what a mess
				local pressed = controls[entry.key]
				if pressed then
					if entry.type == "normal" then
						if (not entry.tap or entry.press_duration == 1) and entry.press_duration % entry.repeat_rate == 0 then
							entry.callback(entry.ctx, {name, entry.key, entry.press_duration})
						end
					end
					entry.press_duration = entry.press_duration + 1
				else
					if entry.type == "release" and entry.press_duration ~= 0 then
						entry.callback(entry.ctx, {name, entry.key, entry.press_duration})
					end
					entry.press_duration = 0
				end
			end
		end
	end
end)

lush.Command:new(
{
	name = "register_control_hook",
	description = "registers a hook to be executed when the player clicks a certain button",
	privs = {server = true},
	options = {tap = false, repeat_rate = true, release = false},
	arguments =
	{
		{
			name = "players",
			type = "player_name",
			single = false,
		},
		{
			rule_type = "terminal",
			name = "key",
			value =
			{
				up = true,
				down = true,
				left = true,
				right = true,
				jump = true,
				aux1 = true,
				sneak = true,
				dig = true,
				place = true,
			}
		},
		{
			name = "callback",
			type = "function",
			single = true
		}
	},
	callback = function(ctx, args, options)
		if options.tap and options.repeat_rate then
			error("options 'tap' and 'repeat_rate' can't be combined")
		end

		local shell_ctx = lush.ShellContext:new()
		shell_ctx.env:inherit(ctx.env)
		shell_ctx.privilege_cache = ctx.privilege_cache

		for _, v in args.players:iterator() do
			control_callbacks[v] = control_callbacks[v] or {}
			table.insert(control_callbacks[v],
			{
				press_duration = 0,
				repeat_rate = options.repeat_rate or 1,
				type = options.release and "release" or "normal",
				key = args.key,
				tap = options.tap,
				ctx = shell_ctx,
				callback = args.callback
			})
		end
	end
})
