-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

local CommandInvocation = require("language_constructs.command_invocation")
local DatatypeValidator = require("datatype_validator")
local helpers = require("helpers")

core.register_on_mods_loaded(function()
	for command_name, command in pairs(core.registered_chatcommands) do
		if lush.global_env:is_param_readonly(command_name) then
			-- core.unregister_chatcommand(command_name)
		else
			lush.global_env:set(command_name, function(ctx, args)
				local params_table = {}
				local params = ""

				for _, v in pairs(args) do

					if type(v) == "table" and v.instance_of == "TypedList" then
						v = v:get(1)
					end

					v = DatatypeValidator.cast_to(v, "string")

					table.insert(params_table, v)
				end

				params = table.concat(params_table, " ")

				core.log(
					string.format('"%s" is not a native lush command, using compatibility layer\npassed params: "%s"', command_name, params)
				)

				local success, stdout = command.func(ctx.env:get("name"), params)

				if success then
					ctx.exit_status = 0
					if stdout then
						ctx.stdout:concat(helpers.string_split(stdout, "\n"))
					end
				else
					error(stdout)
				end
			end, true, true)
		end
	end
end)

return CommandInvocation
