-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

local InlineLua = require("language_constructs.inline_lua")

local is_enabled = core.settings:get_bool("lush_inline_lua")

-- setting default value
if is_enabled == nil then
	is_enabled = true
end

if is_enabled then
	local old_eval = InlineLua.evaluate
	InlineLua.evaluate = function(self, ctx)
		if ctx.privilege_cache["lush_inline_lua"] then
			return old_eval(self, ctx)
		else
			error("you dont have privilages to execute lua code")
		end
	end

else
	InlineLua = {} -- clearing everything

	function InlineLua.parser(parser_ctx)
		error("inline lua is disabled on this server")
	end

	function InlineLua.new(self, t)
		error("inline lua is disabled on this server")
	end
end

return InlineLua
