-- Copyright (C) 2025 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

local operators =
{
	["."] =
	{
		type = "between_two",
		priority = 0,
		action = function(lhs, rhs)
			return lhs[rhs]
		end,
	},
	["["] =
	{
		type = "around",
		ending_terminal = "]",
		priority = 0,
		action = function(lhs, rhs)
			if lhs.instance_of == "TypedList" then
				return lhs:get(rhs)
			end
			return lhs[rhs]
		end,
	},
	["#"] =
	{
		type = "unary",
		priority = 1,
		action = function(exp)
			return #exp
		end
	},
	["not"] =
	{
		type = "unary",
		priority = 2,
		action = function(exp)
			return not exp
		end
	},
	["bnot"] =
	{
		type = "unary",
		priority = 2,
		action = function(exp)
			return bit.bnot(exp)
		end
	},
	["%"] =
	{
		type = "between_two",
		priority = 3,
		action = function(lhs, rhs)
			return lhs % rhs
		end
	},
	["^"] =
	{
		type = "between_two",
		priority = 3,
		action = function(lhs, rhs)
			return lhs ^ rhs
		end
	},
	["*"] =
	{
		type = "between_two",
		priority = 4,
		action = function(lfs, rhs)
			return lfs * rhs
		end
	},
	["/"] =
	{
		type = "between_two",
		priority = 4,
		action = function(lhs, rhs)
			return lhs / rhs
		end
	},
	["+"] =
	{
		type = "between_two",
		priority = 5,
		action = function(lhs, rhs)
			return lhs + rhs
		end
	},
	["-"] =
	{
		type = "between_two",
		priority = 5,
		action = function(lhs, rhs)
			return lhs - rhs
		end
	},
	[">"] =
	{
		type = "between_two",
		priority = 9,
		action = function(lhs, rhs)
			return lhs > rhs
		end
	},
	[">="] =
	{
		type = "between_two",
		priority = 9,
		action = function(lhs, rhs)
			return lhs >= rhs
		end
	},
	["<"] =
	{
		type = "between_two",
		priority = 9,
		action = function(lhs, rhs)
			return lhs < rhs
		end
	},
	["<="] =
	{
		type = "between_two",
		priority = 9,
		action = function(lhs, rhs)
			return lhs <= rhs
		end
	},
	["=="] =
	{
		type = "between_two",
		priority = 10,
		action = function(lhs, rhs)
			return lhs == rhs
		end
	},
	["!="] =
	{
		type = "between_two",
		priority = 10,
		action = function(lhs, rhs)
			return lhs ~= rhs
		end
	},
	[">>"] =
	{
		type = "between_two",
		priority = 7,
		action = function(lhs, rhs)
			return bit.rshift(lhs, rhs)
		end
	},
	["<<"] =
	{
		type = "between_two",
		priority = 7,
		action = function(lhs, rhs)
			return bit.lshift(lhs, rhs)
		end
	},
	["band"] =
	{
		type = "between_two",
		priority = 11,
		action = function(lhs, rhs)
			return bit.band(lhs, rhs)
		end
	},
	["bxor"] =
	{
		type = "between_two",
		priority = 12,
		action = function(lhs, rhs)
			return bit.bxor(lhs, rhs)
		end
	},
	["bor"] =
	{
		type = "between_two",
		priority = 13,
		action = function(lhs, rhs)
			return bit.bor(lhs, rhs)
		end
	},
	["and"] =
	{
		type = "between_two",
		priority = 14,
		action = function(lhs, rhs)
			return lhs and rhs
		end
	},
	["or"] =
	{
		type = "between_two",
		priority = 15,
		action = function(lhs, rhs)
			return lhs or rhs
		end
	},
	[".."] =
	{
		type = "between_two",
		priority = 13,
		action = function(lhs, rhs)
			return lhs .. rhs
		end,
	},
}

for k, v in pairs(operators) do
	v.name = k
end

return operators
