-- Copyright (C) 2025 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

local DumpContext =
{
	instance_of = "DumpContext",
}

DumpContext.__index = DumpContext

function DumpContext:new(t)
	if t == nil then
		t = {}
	end

	-- {{{ type checking
	assert(type(t) == "table", "t should be of type table. instead of " .. type(t))
	assert(not t.character_index or type(t.character_index) == "number", "t.character_index should be of type number. instead of " .. type(t.character_index))
	assert(not t.text or type(t.text) == "string", "t.text should be of type string. instead of " .. type(t.text))
	-- }}}

	self = setmetatable(
	{
		tab_level = t.tab_level or 0,
		string_buffer = t.text_buffer or {},
		use_color = true
	}, DumpContext)

	return self
end

function DumpContext:write_line(text, dont_start_new_line)
	table.insert(self.string_buffer, string.rep("\t", self.tab_level) .. text .. (dont_start_new_line and "" or "\n"))
end

function DumpContext:new_line()
	table.insert(self.string_buffer, "\n" .. string.rep("\t", self.tab_level))
end

function DumpContext:write_text(text)
	table.insert(self.string_buffer, text)
end

function DumpContext:indent(amount)
	amount = amount or 1
	self.tab_level = self.tab_level + amount
end

-- The actual implementation is in minetest/dump_context, since core.colorize is needed
---@diagnostic disable-next-line: unused-local
function DumpContext:color(text, color_name)
	return text
end

function DumpContext:render()
	return table.concat(self.string_buffer)
end

return DumpContext
