
local Interpreter = require("interpreter")

local old_run_shell = Interpreter.run_shell

function Interpreter.run_shell(code, initial_context, options)
	if options then
		options.get_time = core.get_us_time
	else
		options = {get_time = core.get_us_time}
	end

	return old_run_shell(code, initial_context, options)
end

local old_run_command = Interpreter.run_command
function Interpreter.run_command(code, initial_context, options)
	if initial_context then
		initial_context.privilege_cache = core.get_player_privs(initial_context.env:get("name"))
	else
		initial_context = {privilege_cache = core.get_player_privs(initial_context.env:get("name"))}
	end

	if options then
		options.get_time = core.get_us_time
	else
		options = {get_time = core.get_us_time}
	end

	return old_run_command(code, initial_context, options)
end

return Interpreter
