-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

require("tests.busted_definitions")
require("tests.command_definitions")

describe("component tests: ",
function()
	local Interpreter = require("interpreter")
	local Env = require("env")
	local env_instance

	before_each(
	function()
		env_instance = Env:new()
		env_instance:inherit(lush.global_env)
	end)

	it("prime numbers",
	function()
		local search_until = 50

		env_instance:set("search_until", search_until)
		Interpreter.run_file("tests/component_tests/prime_numbers.lush", {env = env_instance},
		{
			get_time = os.time,
			complete_callback = function(success, err_msg, ctx)
				assert.equals("", err_msg)
				assert.equals(true, success)
				-- calculate the correct output in lua
				local output = {}
				for i = 1, search_until do
					is_first = true

					for j = 2, math.sqrt(i) do
						if i % j == 0 then
							is_first = false
							break
						end
					end

					if is_first then
						table.insert(output, tostring(i))
					end
				end

				for i, v in ipairs(output) do
					assert.equals(v, ctx.stdout:get(i))
				end
			end
		})
	end)

	it("base2",
	function()
		env_instance:set("n", 73)

		Interpreter.run_file("tests/component_tests/base2.lush", {env = env_instance},
		{
			get_time = os.time,
			complete_callback = function(success, err_msg, ctx)
				assert.equals(err_msg, "")
				assert.equals(success, true)
				assert.equals(ctx.stdout:get(1), "1001001")
			end
		})
	end)
end)
