-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

require("tests/busted_definitions")
require("type_definitions")

describe("TypedList class: ",
function()
	local TypedList = require("typed_list")
	local typed_list_instance

	before_each(
	function()
		typed_list_instance = TypedList:new()
	end)

	it("pushing elements works",
	function()
		typed_list_instance:push("element")
		typed_list_instance:push("element2")
		typed_list_instance:push("element3")

		assert.same({"element", "element2", "element3"}, typed_list_instance.container)
		assert.equals("string", typed_list_instance.type)
	end)

	it("errors when pushing an element that has the wrong datatype",
	function()
		typed_list_instance:push(1)

		assert.errors(function() typed_list_instance:push("hello world") end)
	end)

	it("getting elements works",
	function()
		typed_list_instance:push("element")

		assert.equals("element", typed_list_instance:get(1))
	end)

	it("popping elements works",
	function()
		typed_list_instance:push("element")
		typed_list_instance:push("element2")

		assert.equals("element2", typed_list_instance:pop(1))
		assert.equals("element", typed_list_instance:pop(1))
		assert.equals("", typed_list_instance.type)
	end)
	
	it("concatting other typed lists works", 
	function()
		local new_typed_list = TypedList:new()

		new_typed_list:push("elem1")
		new_typed_list:push("elem2")
		new_typed_list:push("elem3")

		typed_list_instance:push("among us")
		typed_list_instance:push("fortnight")

		typed_list_instance:concat(new_typed_list)
		
		assert.same({"among us", "fortnight", "elem1", "elem2", "elem3"}, typed_list_instance.container)
	end)

	it("concatting other typed lists works when they have differing types (implicit conversion)", 
	function()
		local new_typed_list = TypedList:new()

		new_typed_list:push(1)
		new_typed_list:push(2)
		new_typed_list:push(3)

		typed_list_instance:push("among us")
		typed_list_instance:push("fortnight")

		typed_list_instance:concat(new_typed_list)
		
		assert.same({"among us", "fortnight", "1", "2", "3"}, typed_list_instance.container)
	end)

	it("setting elements works",
	function()
		typed_list_instance:push("element")
		typed_list_instance:push("element2")
		typed_list_instance:set(2, "second_element")

		assert.equals("second_element", typed_list_instance:get(2))
	end)
end)
