-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

-- reimplementing commands from Wuzzy's findbiome mod to use lush's API

lush.Command:new(
{
	name = "lsbiomes",
	description = "prints all registered biomes to STDOUT",
	privs = {debug = true},
	arguments = {},
	callback = function(ctx, args, options)
		local success, biomes = findbiome.list_biomes()

		if success then
			for _, biome_name in pairs(biomes) do
				ctx.stdout:push(biome_name)
			end
		else
			error(biomes[1])
		end
	end,
})

lush.Command:new(
{
	name = "findbiome",
	description = "find any of the specified biomes and prints it to STDOUT/teleports player there",
	options =
	{
		["tp"] = false,
		["start-pos"] = true,
		["resolution"] = true,
		["check-amount"] = true,
	},
	privs = {debug = true},
	arguments =
	{
		{
			rule_type = "block",
			name = "biomes",
			type = "string",
			required = true,
		}
	},
	callback = function(ctx, args, options)
		local pos, success = findbiome.find_biome(options["start-pos"] or ctx.env:get("pos"), args.biomes, options["resolution"], options["check-amount"])

		if success then
			ctx.stdout:push(vector.new(pos))

			if options["tp"] then
				if not core.check_player_privs(ctx.env:get("name"), "teleport") then
					error("you need 'teleport' priviledge to teleport")
				end

				core.get_player_by_name(ctx.env:get("name")):set_pos(pos)
			end
		else
			error("couldnt find biome")
		end
	end,
})
