-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

lush.Command:new(
{
	name = "call",
	description = "calls a lua function",
	privs = {lush_inline_lua = true},
	arguments =
	{
		{
			name = "function",
			type = "string",
			single = true
		},
		{
			rule_type = "block",
			name = "arguments",
			required = false
		}
	},
	callback = function(ctx, args, options)
		local members = lush.helpers.string_split(args["function"], ".", false)
		local head = _G

		for _, v in pairs(members) do
			head = head[v]
		end

		ctx.stdout:push(head(unpack(args.arguments)))
	end,
})

lush.Command:new(
{
	name = "get",
	description = "gets a variable from global scope",
	privs = {lush_inline_lua = true},
	arguments =
	{
		{
			name = "identifier",
			type = "string",
			single = true
		}
	},
	callback = function(ctx, args, options)
		local members = lush.helpers.string_split(args.identifier, ".", false)
		local head = _G

		for _, v in pairs(members) do
			head = head[v]
		end

		ctx.stdout:push(head)
	end,
})

local registration_functions =
{
	node = core.register_node,
	craftitem = core.register_craftitem,
	tool = core.register_tool,
	entity = core.register_entity,
	privilege = core.register_privilege
}

lush.Command:new(
{
	name = "register",
	description = "registers nodes, items, etc. Consult the minetest docs",
	privs = {lush_inline_lua = true},
	arguments =
	{
		{
			rule_type = "terminal",
			name = "type",
			value = {node = true, craftitem = true, tool = true, entity = true, privilege = true},
		},
		{
			name = "name",
			type = "string",
			single = true
		},
		{
			name = "definition",
			type = "table",
			single = true
		}
	},
	callback = function(ctx, args, options)
		registration_functions[args.type](args.name, args.definition)
	end,
})
