-- Copyright (C) 2024 rstcxk
--
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

local Bool =
{
	instance_of = "LanguageConstruct_Bool",
	static = true
}

Bool.__index = Bool

function Bool:new(t)
	t = t or {}

	self = setmetatable(
	{
		value = t.value or false
	}, Bool)
	self.__index = self

	return self
end

function Bool:evaluate(ctx)
	-- {{{ type checking
	assert(ctx.instance_of == "ShellContext", "ctx should be an instance of ShellContext. instead of " .. ctx.instance_of)
	-- }}}

	return self.value
end

function Bool:static_eval()
	return self.value
end

local helpers = require("helpers")
local boolean_tire = helpers.create_trie({"true", "false"})

function Bool:parse(parser_ctx)
	-- {{{ type checking
	assert(parser_ctx.instance_of == "ParserContext", "parser_ctx should be an instance of ParserContext. instead of " .. parser_ctx.instance_of)
	-- }}}

	local success, terminator = parser_ctx:match(boolean_tire, true)

	assert(success, "invalid boolean value")

	self.value = terminator == "true"
end

function Bool:dump(dump_ctx)
	local prefix = dump_ctx:color("(Bool) ", "ConstructSpecifier")
	dump_ctx:write_text(string.format("%s%s", prefix, dump_ctx:color(self.value and "TRUE" or "FALSE", "Bool")))
end

return Bool
