-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

local Env = require("env")
local EnvStud = require("env_stud")

-- dictionary
-- where the key is a name of the player
-- and the value is an Env instance
lush.player_environments = {}

-- dictionary
-- where the key is a name of the player
-- and the value is a dictionary of parameters
local player_parameters = lush.Storage.load("player_parameters", {})

Env.modify_on_player_join =
{
	function(stud, name, last_login)
		stud:special_set("name", name)
	end,

	function(stud, name, last_login)
		stud:special_set("pos", function(self)
			return core.get_player_by_name(self:get("name")):get_pos()
		end)
	end,
}

core.register_on_mods_loaded(function()
    core.register_on_joinplayer(function(player, last_login)
		local name = player:get_player_name()

		local players_env = Env:new({parameters = player_parameters[name] or {}})
		local stud_env = EnvStud:new()

		for _, func in pairs(Env.modify_on_player_join) do
			func(stud_env, name, last_login)
		end

		stud_env:inherit(players_env)
		players_env:inherit(lush.global_env)

		lush.player_environments[name] = stud_env
    end)
end)

local old_set = Env.set

Env.set = function(self, key, value, read_only, volatile)
	local val_type = type(value)
	if val_type == "userdata" or val_type == "function" then
		-- error("userdata (like ObjectRefs) are not allowed in lush environments")
		-- see if this possibly causes issues
		volatile = true
	end

	old_set(self, key, value, read_only, volatile)
end

return Env
