-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

S = core.get_translator(minetest.get_current_modname())

for power_level = 0, 15 do
	core.register_node("redstonepp:power_block_" .. power_level,
	{
		paramtype = "light",
		description = S("Power block"),
		drop = "redstonepp:power_block_0",
		tiles = {"redstonepp_power_block_" .. power_level .. ".png"},
		groups = {not_in_creative_inventory = power_level ~= 0 and 1 or nil},
		on_rightclick = function(pos)
			core.set_node(pos, {name = "redstonepp:power_block_" .. (power_level + 1) % 16})
		end,
		_mcl_redstone =
		{
			connects_to = function(node, dir)
				return true
			end,
			get_power = function()
				return power_level, false
			end
		}
	})
end

minetest.register_craft({
	output = "redstonepp:power_block_0",
	recipe = {
		{"mcl_redstone:redstone", "mcl_redstone:redstone", "mcl_redstone:redstone"},
		{"mcl_redstone:redstone", "mcl_buttons:button_stone_off", "mcl_redstone:redstone"},
		{"mcl_redstone:redstone", "mcl_redstone:redstone", "mcl_redstone:redstone"},
	},
})
