-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

local function spawn_tnt(pos)
	minetest.sound_play("tnt_ignite", { pos = pos, gain = 1.0, max_hear_distance = 15 }, true)
	local ent = minetest.add_entity(pos, "mcl_tnt:tnt")
	if ent then
		ent:set_armor_groups({ immortal = 1 })
	end
	return ent
end

core.register_node("redstonepp:tnt_duper", {
	description = "tnt duper",
	groups = {handy=1, not_opaque=1},
	paramtype = "light",
	paramtype2 = "facedir",
	is_ground_content = false,
	_mcl_blast_resistance = 0.5,
	_mcl_hardness = 0.5,
	tiles = {
		"tnt_duper_side.png^[transformR90",
		"tnt_duper_side.png^[transformR270",
		"tnt_duper_side.png",
		"tnt_duper_side.png",
		"tnt_duper_back.png",
		"tnt_duper_front.png"
	},
	_mcl_redstone =
	{
		update = function(pos, node)
			if mcl_redstone.get_power(pos) > 0 then
				dir = -core.facedir_to_dir(node.param2, true)
				spawn_tnt(pos + dir)
			end
		end
	}
})

minetest.register_craft({
	output = "redstonepp:tnt_duper",
	recipe = {
		{"mcl_blackstone:blackstone", "mcl_blackstone:blackstone", "mcl_blackstone:blackstone"},
		{"mcl_tnt:tnt", "mcl_dispensers:dispenser", "mcl_nether:netherite_ingot"},
		{"mcl_blackstone:blackstone", "mcl_blackstone:blackstone", "mcl_blackstone:blackstone"},
	},
})
