
# Redstone plus plus

# Features

## coloured lamps

Coloured lamps are nodes that change colour depending on the incoming power level. The power level is interpreted as a 4 bit
bitmap with the following format:

- first bit decides if the colour has red
- second bit decides if the colour has green
- third bit decides if the colour has blue
- fourth bit decides if the colour is bright

Heres a table of all possible combinations


| power level  |      colour     |
|--------------|-----------------|
|           0  |  black          |
|           1  |  red            |
|           2  |  green          |
|           3  |  yellow         |
|           4  |  blue           |
|           5  |  magenta        |
|           6  |  cyan           |
|           7  |  grey*          |
|           8  |  grey*          |
|           9  |  bright red     |
|          10  |  bright green   |
|          11  |  bright yellow  |
|          12  |  bright blue    |
|          13  |  bright magenta |
|          14  |  bright cyan    |
|          15  |  white          |


![all colours](https://codeberg.org/xXx_GLOCKrzmitz_xXx/redstonePlusPlus/raw/branch/master/screenshots/coloured_lamps.png)

*the meaning of power levels of 8 and 7 are ambigious and its unclear which one should be brighter. Might change in the future

**coloured lamps dont actually emit any light. So switching colours dosent need to update the world's light

## Power block

Outputs the power level specified by the label. Right click to increase the power level. Above the label the binary representation
of that power level is shown

## Redstone radio

Redstone radio is able to recieve and transmit redstone power over air anywhere in the world. The power is only sent to recievers
that are configured to pick up that channel

When placed the inputs look like:

![all colours](https://codeberg.org/xXx_GLOCKrzmitz_xXx/redstonePlusPlus/raw/branch/master/screenshots/radio_explanation.png)

The channel inputs specify what recievers will pick up the signal. The direction from which power comes and power level uniqely
identify the channel. All these recievers have a different channel 

![radio combination 1](https://codeberg.org/xXx_GLOCKrzmitz_xXx/redstonePlusPlus/raw/branch/master/screenshots/radio_channel_1.png)
![radio combination 2](https://codeberg.org/xXx_GLOCKrzmitz_xXx/redstonePlusPlus/raw/branch/master/screenshots/radio_channel_2.png)
![radio combination 3](https://codeberg.org/xXx_GLOCKrzmitz_xXx/redstonePlusPlus/raw/branch/master/screenshots/radio_channel_3.png)
![radio combination 4](https://codeberg.org/xXx_GLOCKrzmitz_xXx/redstonePlusPlus/raw/branch/master/screenshots/radio_channel_4.png)

This means that there are 4096 unique channels

Redstone radio has 2 modes

- Recievers - the radio reads the power level at specified channel and outputs it
- Transmiters - the radio reads the rear power and transmits it to the specified channel

### Important notes

The recievers dont immedietely detect when the power level changes. Dont depend on them for anything timing related

The channels arent presistent over server reloads. So if you restart the game and the transmitter is unloaded. The reciever will
not output any power

## TNT duper

When powered, drops a single piece of tnt

## Redstone breakpoint

When powered it stops all further redstone updates in the world. Allowing to easily debug circuits.

When triggered you can rightclick it to actiavte ticking again. Or use the `tick` command

# Contributing

Everyone is welcome to contribute. In the form of feature requests, PRs, bug reports, new textures or any other improvement

If you want to implement something yourself but dont know how, you are welcome to open an issue about it as a feature request and
i can guide how (in my opinion) its best implemented, or useful things to look out for

What new features are accepted? Anything redstone related as long as it make new things possible

**but** not if its just about trivializing building redstone circuits. For example AND, or OR gates are already possible to
build with regular redstone components, so adding them as single nodes would trivialize things and you'd never build them the
regular way. Which IMO takes away from the quirky and unique way redstone works

# License

Redstone++ is licensed under AGPLv3

AGPLv3 dosent bite :)
