-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

local S = minetest.get_translator(minetest.get_current_modname())

-- pallete explanation
-- the color of the lamp is determined by its power level, the power level is read like bitmap with following format
-- first bit: red
-- second bit: green
-- third bit: blue
-- fourth bit: light
--
-- to get colors like yellow, magenta and cyan you can use bitwise OR to combine red, green and blue
-- 1000 (red) | 0100 (green) = 1100 (yellow)
--
-- if no bits are set, the lamp will be off
-- if only the fourth bit is set, the lamp will be grey. You can get various shades of white/gray with these combinations:
-- no bits set - black
-- only fourth bit set - dark grey
-- all bits sed besides fourth - grey
-- all bits sed - white

local light = minetest.LIGHT_MAX

local commdef = {
	groups = {handy=1, opaque = 1},
	is_ground_content = false,
	paramtype = "light",
	paramtype2 = "color",
	palette = "colored_lamp_pallete.png",
	tiles = {"redstonepp_colored_lamp.png"},
	description = S("Colored lamp"),
	drop = "redstonepp:colored_lamp_off",
	sounds = mcl_sounds and mcl_sounds.node_sound_glass_defaults() or nil,
	_mcl_blast_resistance = 0.3,
	_mcl_hardness = 0.3,
	_mcl_redstone = {
		connects_to = function(node, dir)
			return true
		end,
		update = function(pos, node)
			-- core.debug(dump(pos))
			local power = mcl_redstone.get_power(pos)
			if power ~= 0 then
				return {priority = 1, name = "redstonepp:colored_lamp_on", param2 = power}
			else
				return {name = "redstonepp:colored_lamp_off"}
			end
		end,
	},
}

minetest.register_node("redstonepp:colored_lamp_off", commdef)

minetest.register_node("redstonepp:colored_lamp_on", table.merge(commdef, {
	groups = table.merge(commdef.groups, {not_in_creative_inventory=1}),
	light_source = light,
}))

minetest.register_craft({
	output = "mcl_redstone_lamp:lamp_off",
	type = "shapeless",
	recipe = {"mcl_redstone_lamp:lamp_off", "mcl_dyes:red", "mcl_dyes:blue", "mcl_dyes:green"}
})
