-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

-- chains have this weird convention for param2 which
-- makes it impossible to use core.facedir_to_dir()
-- as such, a translation table is needed
local translation_table =
{
	[12] = "x",
	[16] = "x",
	[0] = "y",
	[1] = "y",
	[2] = "y",
	[3] = "y",
	[4] = "z",
	[8] = "z",
}

minetest.override_item("mcl_lanterns:chain", 
{
	_mcl_pistons_sticky = function (node, node_to, dir)
		local chain_dir = translation_table[node.param2]
		core.debug(dump(node_to), dump(dir), dump(chain_dir))
		return dir[chain_dir] ~= 0;
	end
})
