local modes = {
	unit = {
		update = function(_, player, context, unit)
			player:hud_set_flags({
				wielditem = false,
			})

			local unit_def = unit:get_luaentity():get_unit_type()

			if not context.bg then
				context.bg = player:hud_add({
					hud_elem_type = "image",
					position  = {x = 0.5, y = 0.95},
					offset    = {x = 0, y = 0},
					text      = "conquer_gui_hotbar_unit.png",
					scale     = { x = 1, y = 1},
					alignment = { x = 0, y = -1 },
					z_index   = -100,
				})
			end

			if not context.hotbar then
				context.hotbar = player:hud_add({
					hud_elem_type = "inventory",
					position  = {x = 0.5, y = 0.95},
					offset    = {x = -125, y = -70},
					text      = "main",
					number    = 3,
					item      = player:get_wield_index(),
					direction = 0
				})
			end

			if context.icon then
				player:hud_change(context.icon, "text", unit_def.icon)
			else
				context.icon = player:hud_add({
					hud_elem_type = "image",
					position  = {x = 0.5, y = 0.95},
					offset    = {x = -180 - 4, y = -70 + 64 - 5 - 9},
					text      = unit_def.icon,
					scale     = { x = 3, y = 3},
					alignment = { x = 0, y = -1 },
					z_index   = -100,
				})
			end
		end,

		set_inv = function(_, _, inv, unit)
			inv:set_list("main", {
				ItemStack("conquer:move"),
			})

			local def = unit:get_luaentity():get_unit_type()

			if def.melee then
				inv:add_item("main", "conquer:melee")
			end

			if def.ranged then
				inv:add_item("main", "conquer:ranged")
			end
		end,
	},

	build = {
		update = function(_, player, context)
			player:hud_set_flags({
				wielditem = true,
			})

			if not context.bg then
				context.bg = player:hud_add({
					hud_elem_type = "image",
					position  = {x = 0.5, y = 0.95},
					offset    = {x = 0, y = 0},
					text      = "conquer_gui_hotbar_build.png",
					scale     = { x = 1, y = 1},
					alignment = { x = 0, y = -1 },
					z_index   = -100,
				})
			end

			if not context.hotbar then
				context.hotbar = player:hud_add({
					hud_elem_type = "inventory",
					position  = {x = 0.5, y = 0.95},
					offset    = {x = -83, y = -70},
					text      = "main",
					number    = 3,
					item      = player:get_wield_index(),
					direction = 0
				})
			end
		end,

		set_inv = function(_, _, inv, _)
			inv:set_list("main", {
				ItemStack("conquer:keep"),
				ItemStack("conquer:barracks"),
			})
		end,
	},
}


local function remove_all_huds(player, context)
	for key, value in pairs(context) do
		if type(value) == "number" then
			player:hud_remove(value)
		end
		context[key] = nil
	end
end

local hud_context_provider = conquer.make_context_provider()

local function update_hud(player, _, unit)
	local context = hud_context_provider(player)
	local mode = unit and "unit" or "build"

	-- Clear all elements on HUD change
	if context.mode and context.mode ~= mode then
			remove_all_huds(player, context)
	end

	-- Update inventory
	if context.mode ~= mode or (mode == "unit" and unit ~= context.selected_unit) then
		modes[mode]:set_inv(player, player:get_inventory(), unit)
	end

	context.mode = mode
	context.selected_unit = unit
	modes[mode]:update(player, context, unit)
end

local function update_hotbar_selected_items()
	local players = minetest.get_connected_players()
	for i=1, #players do
		local player = players[i]
		local context = hud_context_provider(player)
		if context.hotbar then
			local hotbar_idx = player:get_wield_index()
			if hotbar_idx ~= context.hotbar_idx then
				player:hud_change(context.hotbar, "item", hotbar_idx)
				context.hotbar_idx = hotbar_idx
			end
		end
	end

	minetest.after(0.1, update_hotbar_selected_items)
end

minetest.after(0.1, update_hotbar_selected_items)

conquer.register_on_selected_unit_changed(function(player, _, country, unit)
	update_hud(player, country, unit)
end)

conquer.register_on_change_country(function(player, _, country)
	update_hud(player, country, conquer.get_selected_unit(player))
end)



--
-- Hide default stuff when in a session
--

local hud_builtin_defaults_context_provider = conquer.make_context_provider()

conquer.register_on_join_session(function(player)
	local context = hud_builtin_defaults_context_provider(player)
	context.hotbar_image = player:hud_get_hotbar_image()
	context.hotbar_selected_image = player:hud_get_hotbar_selected_image()
	context.flags = player:hud_get_flags()

	player:hud_set_hotbar_image("")
	player:hud_set_hotbar_selected_image("")
	player:hud_set_flags({
		hotbar = false,
		healthbar = false,
		breathbar = false,
	})

	local inv = player:get_inventory()
	inv:set_size("mainbackup", inv:get_size("main"))
	inv:set_list("mainbackup", inv:get_list("main"))
	inv:set_size("main", 3)
	inv:set_list("main", {})
end)

conquer.register_on_leave_session(function(player)
	local context = hud_builtin_defaults_context_provider(player)

	player:hud_set_hotbar_image(context.hotbar_image)
	player:hud_set_hotbar_selected_image(context.hotbar_selected_image)
	player:hud_set_flags(context.flags)

	remove_all_huds(player, hud_context_provider(player))

	local inv = player:get_inventory()
	inv:set_size("main", inv:get_size("mainbackup"))
	inv:set_list("main", inv:get_list("mainbackup"))
	inv:set_size("mainbackup", 0)
end)



local old_item_drop = minetest.item_drop
minetest.item_drop = function(itemstack, player, pos)
	if conquer.get_session(player) then
		minetest.chat_send_player(player:get_player_name(),
			"You're not allowed to drop items!")
		return itemstack
	else
		return old_item_drop(itemstack, player, pos)
	end
end
